/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.ToolRule;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class ToolItemStackData {
    private ToolItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.EFFICIENCY).get(h -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                return tool.defaultMiningSpeed();
            }
            return null;
        })).set((h, v) -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                h.set(DataComponents.TOOL, (Object)new Tool(tool.rules(), v.floatValue(), tool.damagePerBlock()));
                return;
            }
            h.set(DataComponents.TOOL, (Object)new Tool(List.of(), v.floatValue(), 1));
        })).delete(h -> h.remove(DataComponents.TOOL))).create(Keys.TOOL_DAMAGE_PER_BLOCK).get(h -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                return tool.damagePerBlock();
            }
            return null;
        })).set((h, v) -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                h.set(DataComponents.TOOL, (Object)new Tool(tool.rules(), tool.defaultMiningSpeed(), v.intValue()));
                return;
            }
            h.set(DataComponents.TOOL, (Object)new Tool(List.of(), 1.0f, v.intValue()));
        })).create(Keys.TOOL_RULES).get(h -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool == null) {
                return null;
            }
            return tool.rules().stream().map(ToolRule.class::cast).toList();
        })).set((h, v) -> {
            List<Tool.Rule> mcValue = v.stream().map(Tool.Rule.class::cast).toList();
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                h.set(DataComponents.TOOL, (Object)new Tool(mcValue, tool.defaultMiningSpeed(), tool.damagePerBlock()));
                return;
            }
            h.set(DataComponents.TOOL, (Object)new Tool(mcValue, 1.0f, 1));
        })).delete(h -> {
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                h.set(DataComponents.TOOL, (Object)new Tool(List.of(), tool.defaultMiningSpeed(), tool.damagePerBlock()));
            }
        })).create(Keys.CAN_HARVEST).get(h -> {
            Registry blockRegistry = SpongeCommon.vanillaRegistry(Registries.BLOCK);
            Tool tool = (Tool)h.get(DataComponents.TOOL);
            if (tool != null) {
                return tool.rules().stream().map(Tool.Rule::blocks).flatMap(HolderSet::stream).map(Holder::value).map(BlockType.class::cast).collect(Collectors.toSet());
            }
            Set blockTypes = blockRegistry.stream().filter(b -> h.isCorrectToolForDrops(b.defaultBlockState())).map(BlockType.class::cast).collect(Collectors.toUnmodifiableSet());
            return blockTypes.isEmpty() ? null : blockTypes;
        });
    }
}

