/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import java.util.function.BiFunction;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.value.ValueConstructor;

final class SimpleValueConstructor<V extends Value<E>, E>
implements ValueConstructor<V, E> {
    private final Key<V> key;
    private final BiFunction<Key<V>, E, V> mutableConstructor;
    private final BiFunction<Key<V>, E, V> immutableConstructor;

    public SimpleValueConstructor(Key<V> key, BiFunction<Key<V>, E, V> mutableConstructor, BiFunction<Key<V>, E, V> immutableConstructor) {
        this.key = key;
        this.mutableConstructor = mutableConstructor;
        this.immutableConstructor = immutableConstructor;
    }

    @Override
    public V getMutable(E element) {
        return (V)((Value)this.mutableConstructor.apply(this.key, element));
    }

    @Override
    public V getRawImmutable(E element) {
        return (V)((Value)this.immutableConstructor.apply(this.key, element));
    }
}

