/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.datapack.DataPackDecoder;
import org.spongepowered.common.datapack.DataPackEncoder;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;

public class NbtDataPackSerializer<T extends DataPackEntry<T>>
extends DataPackSerializer<CompoundTag, T> {
    public NbtDataPackSerializer(DataPackEncoder<CompoundTag, T> encoder, DataPackDecoder<CompoundTag, T> decoder) {
        super(encoder, decoder);
    }

    @Override
    public String fileEnding() {
        return ".nbt";
    }

    @Override
    public void serializeObject(SpongeDataPack<CompoundTag, T> pack, Path packDir, T packEntry) throws IOException {
        CompoundTag serialized = (CompoundTag)this.encoder.encode(packEntry, (RegistryAccess)SpongeCommon.server().registryAccess());
        Path file = this.packEntryFile(pack.type(), packEntry.key(), packDir);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        NbtDataPackSerializer.writeFile(file, serialized);
    }

    @Override
    protected void serializeAdditional(SpongeDataPack<CompoundTag, T> type, Path packDir, T entry) throws IOException {
    }

    @Override
    public T deserialize(SpongeDataPack<CompoundTag, T> pack, Path file, ResourceKey key) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            T t = this.deserialize(pack, stream, key);
            return t;
        }
    }

    @Override
    public T deserialize(SpongeDataPack<CompoundTag, T> pack, InputStream is, ResourceKey key) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            CompoundTag element = NbtIo.readCompressed((InputStream)dis, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (this.decoder != null) {
                Object t = this.decoder.decode(pack, key, element, (RegistryAccess)SpongeCommon.server().registryAccess());
                return t;
            }
        }
        return null;
    }

    public static void writeFile(Path file, CompoundTag object) throws IOException {
        Files.deleteIfExists(file);
        NbtIo.writeCompressed((CompoundTag)object, (Path)file);
    }
}

