/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelData;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.server.level.ServerPlayerAccessor;
import org.spongepowered.common.accessor.server.network.ServerCommonPacketListenerImplAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.PlatformServerLevelBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.math.vector.Vector3d;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static void despawnFilteredEntities(Iterable<? extends net.minecraft.world.entity.Entity> originalEntities, SpawnEntityEvent event) {
        if (event.isCancelled()) {
            for (net.minecraft.world.entity.Entity entity : originalEntities) {
                entity.discard();
            }
        } else {
            for (net.minecraft.world.entity.Entity entity : originalEntities) {
                if (event.entities().contains(entity)) continue;
                entity.discard();
            }
        }
    }

    public static void performPostChangePlayerWorldLogic(ServerPlayer player, ServerLevel fromWorld, ServerLevel originalToWorld, ServerLevel toWorld, boolean isPortal) {
        ((ServerPlayerBridge)player).bridge$sendDimensionData(((ServerCommonPacketListenerImplAccessor)player.connection).accessor$connection(), toWorld.dimensionType(), (ResourceKey<Level>)toWorld.dimension());
        LevelData worldinfo = toWorld.getLevelData();
        if (!isPortal) {
            ((ServerPlayerBridge)player).bridge$sendChangeDimension((Holder<DimensionType>)toWorld.dimensionTypeRegistration(), (ResourceKey<Level>)toWorld.dimension(), BiomeManager.obfuscateSeed((long)toWorld.getSeed()), player.gameMode.getGameModeForPlayer(), player.gameMode.getPreviousGameModeForPlayer(), toWorld.isDebug(), toWorld.isFlat(), (byte)3);
        }
        player.connection.send((Packet)new ClientboundChangeDifficultyPacket(worldinfo.getDifficulty(), worldinfo.isDifficultyLocked()));
        PlayerList playerlist = player.getServer().getPlayerList();
        playerlist.sendPlayerPermissionLevel(player);
        ((PlatformServerLevelBridge)fromWorld).bridge$removeEntity((net.minecraft.world.entity.Entity)player, Entity.RemovalReason.CHANGED_DIMENSION, true);
        ((PlatformEntityBridge)player).bridge$revive();
        player.setServerLevel(toWorld);
        toWorld.addDuringPortalTeleport(player);
        if (isPortal) {
            ((ServerPlayerAccessor)player).invoker$triggerDimensionChangeTriggers(toWorld);
        }
        player.gameMode.setLevel(toWorld);
        player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        playerlist.sendLevelInfo(player, toWorld);
        playerlist.sendAllPlayerInfo(player);
        for (MobEffectInstance effectinstance : player.getActiveEffects()) {
            player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), effectinstance, false));
        }
        if (isPortal) {
            player.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
        ((ServerLevelBridge)fromWorld).bridge$getBossBarManager().onPlayerDisconnect(player);
        ((ServerLevelBridge)toWorld).bridge$getBossBarManager().onPlayerDisconnect(player);
        ((ServerPlayerAccessor)player).accessor$lastSentExp(-1);
        ((ServerPlayerAccessor)player).accessor$lastSentHealth(-1.0f);
        ((ServerPlayerAccessor)player).accessor$lastSentFood(-1);
        if (!isPortal) {
            player.connection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
            player.connection.resetPosition();
        }
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer();
        }
        Sponge.eventManager().post(SpongeEventFactory.createChangeEntityWorldEventPost(PhaseTracker.getCauseStackManager().currentCause(), (Entity)player, (ServerWorld)fromWorld, (ServerWorld)originalToWorld, (ServerWorld)toWorld));
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<UUID>> supplier, Consumer<net.minecraft.world.entity.Entity> spawner) {
        Optional<net.minecraft.world.entity.Entity> customEntityItem;
        ItemStack item;
        net.minecraft.world.entity.Entity minecraftEntity = (net.minecraft.world.entity.Entity)entity;
        if (minecraftEntity instanceof ItemEntity && !(item = ((ItemEntity)minecraftEntity).getItem()).isEmpty() && (customEntityItem = Optional.ofNullable(PlatformHooks.INSTANCE.getWorldHooks().getCustomEntityIfItem(minecraftEntity))).isPresent()) {
            net.minecraft.world.entity.Entity entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(spawned -> {
                if (entityToSpawn instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)entityToSpawn).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, (UUID)spawned);
                }
            });
            if (entityToSpawn.isRemoved()) {
                ((EntityAccessor)entityToSpawn).invoker$unsetRemoved();
            }
            entityToSpawn.level().addFreshEntity(entityToSpawn);
            return true;
        }
        spawner.accept((net.minecraft.world.entity.Entity)entity);
        return true;
    }

    public static Collection<Entity> spawnEntities(Iterable<? extends Entity> entities, Predicate<Entity> selector, Consumer<net.minecraft.world.entity.Entity> spawning) {
        ArrayList<Entity> entitiesToSpawn = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!selector.test(entity)) continue;
            entitiesToSpawn.add(entity);
        }
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().currentCause(), entitiesToSpawn);
        if (Sponge.eventManager().post(event)) {
            return Collections.emptyList();
        }
        for (Entity entity : event.entities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty, spawning);
        }
        return Collections.unmodifiableCollection(new ArrayList<Entity>(event.entities()));
    }

    private static Vector3d createDropMotion(boolean dropAround, Player player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -Mth.sin((float)f1) * f;
            z = Mth.cos((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(player.getXRot() * ((float)Math.PI / 180))) * f2;
            z = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(player.getXRot() * ((float)Math.PI / 180))) * f2;
            y = -Mth.sin((float)(player.getXRot() * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    public static boolean isUntargetable(net.minecraft.world.entity.Entity from, net.minecraft.world.entity.Entity target) {
        if (((VanishableBridge)target).bridge$vanishState().untargetable()) {
            return true;
        }
        return from.level() != target.level();
    }
}

