/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SpongeEntitySnapshot
implements EntitySnapshot,
SpongeImmutableDataHolder<EntitySnapshot>,
DataContainerHolder.Immutable<EntitySnapshot> {
    private final @Nullable UUID uniqueId;
    private final ResourceKey worldKey;
    private final EntityType<?> entityType;
    private final Vector3d position;
    private final Vector3d rotation;
    private final Vector3d scale;
    private final @Nullable CompoundTag compound;
    private final @Nullable WeakReference<Entity> entityReference;

    SpongeEntitySnapshot(SpongeEntitySnapshotBuilder builder) {
        this.entityType = builder.entityType;
        this.uniqueId = builder.uniqueId;
        CompoundTag compoundTag = this.compound = builder.compound == null ? null : builder.compound.copy();
        if (builder.manipulator != null) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$getManipulator().copyFrom(builder.manipulator);
        }
        this.worldKey = builder.worldKey;
        this.position = builder.position;
        this.rotation = builder.rotation;
        this.scale = builder.scale;
        this.entityReference = builder.entityReference;
        if (this.compound != null) {
            this.compound.put("Pos", (Tag)Constants.NBT.newDoubleNBTList(this.position.x(), this.position.y(), this.position.z()));
        }
    }

    public WeakReference<Entity> getEntityReference() {
        return this.entityReference;
    }

    @Override
    public Optional<UUID> uniqueId() {
        return Optional.ofNullable(this.uniqueId);
    }

    @Override
    public Optional<Transform> transform() {
        Transform transform = Transform.of(this.position, this.rotation);
        return Optional.of(transform);
    }

    @Override
    public EntityType<?> type() {
        return this.entityType;
    }

    @Override
    public Optional<ServerLocation> location() {
        Optional<ServerWorld> optional = SpongeCommon.game().server().worldManager().world(this.worldKey);
        if (optional.isPresent()) {
            ServerLocation location = ServerLocation.of(optional.get(), this.position);
            return Optional.of(location);
        }
        return Optional.empty();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(this.compound == null ? new CompoundTag() : this.compound);
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.WORLD_KEY, this.worldKey.formatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, this.position.x()).set(Queries.POSITION_Y, this.position.y()).set(Queries.POSITION_Z, this.position.z()).container().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, this.rotation.x()).set(Queries.POSITION_Y, this.rotation.y()).set(Queries.POSITION_Z, this.rotation.z()).container().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, this.scale.x()).set(Queries.POSITION_Y, this.scale.y()).set(Queries.POSITION_Z, this.scale.z()).container().set(Constants.Entity.TYPE, net.minecraft.world.entity.EntityType.getKey((net.minecraft.world.entity.EntityType)((net.minecraft.world.entity.EntityType)this.entityType))).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        if (this.uniqueId != null) {
            container.set(Constants.Entity.UUID, this.uniqueId.toString());
        }
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return new SpongeEntitySnapshotBuilder().buildContent(container).isPresent();
    }

    @Override
    public EntitySnapshot withRawData(DataView container) throws InvalidDataException {
        Optional<EntitySnapshot> snap = new SpongeEntitySnapshotBuilder().buildContent(container);
        return snap.orElseThrow(InvalidDataException::new);
    }

    @Override
    public EntitySnapshot copy() {
        return this;
    }

    @Override
    public ResourceKey world() {
        return this.worldKey;
    }

    @Override
    public Vector3i position() {
        return this.position.toInt();
    }

    @Override
    public EntitySnapshot withLocation(ServerLocation location) {
        Objects.requireNonNull(location, "location");
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        builder.position = location.position();
        builder.worldKey = ((ServerWorld)location.world()).key();
        builder.compound = new CompoundTag();
        return builder.build();
    }

    private SpongeEntitySnapshotBuilder createBuilder() {
        return ((SpongeEntitySnapshotBuilder)new SpongeEntitySnapshotBuilder().type((EntityType)this.type())).rotation(this.rotation).scale(this.scale);
    }

    public Optional<CompoundTag> getCompound() {
        if (this.compound == null) {
            return Optional.empty();
        }
        return Optional.of(this.compound.copy());
    }

    @Override
    public Optional<Entity> restore() {
        Optional entity;
        Entity entity2;
        if (this.entityReference != null && (entity2 = (Entity)this.entityReference.get()) != null) {
            return Optional.of(entity2);
        }
        Optional<ServerWorld> world = Sponge.server().worldManager().world(this.worldKey);
        if (!world.isPresent()) {
            return Optional.empty();
        }
        if (this.uniqueId != null && (entity = world.get().entity(this.uniqueId)).isPresent()) {
            return entity;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLUGIN);
            Entity newEntity = world.get().createEntity(this.type(), this.position);
            if (newEntity != null) {
                boolean spawnResult;
                net.minecraft.world.entity.Entity nmsEntity = (net.minecraft.world.entity.Entity)newEntity;
                if (this.compound != null) {
                    nmsEntity.load(this.compound);
                }
                if (spawnResult = world.get().spawnEntity((Entity)nmsEntity)) {
                    Optional<Entity> optional = Optional.of((Entity)nmsEntity);
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public EntityArchetype createArchetype() {
        SpongeEntityArchetypeBuilder builder = SpongeEntityArchetypeBuilder.pooled();
        builder.type(this.entityType);
        if (this.compound != null) {
            builder.entityData(NBTTranslator.INSTANCE.translate(this.compound));
        }
        return builder.build();
    }

    @Override
    public DataContainer data$getDataContainer() {
        if (this.compound == null) {
            return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        }
        return NBTTranslator.INSTANCE.translate(this.compound);
    }

    @Override
    public EntitySnapshot data$withDataContainer(DataContainer container) {
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        builder.worldKey = this.worldKey;
        builder.position = this.position;
        builder.compound = NBTTranslator.INSTANCE.translate(container);
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.worldKey, this.entityType, this.position, this.rotation, this.scale);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeEntitySnapshot other = (SpongeEntitySnapshot)obj;
        return Objects.equals(this.uniqueId, other.uniqueId) && Objects.equals(this.worldKey, other.worldKey) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.position, other.position) && Objects.equals(this.rotation, other.rotation) && Objects.equals(this.scale, other.scale);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeEntitySnapshot.class.getSimpleName() + "[", "]").add("uniqueId=" + String.valueOf(this.uniqueId)).add("entityType=" + String.valueOf(this.entityType)).add("position=" + String.valueOf(this.position)).add("rotation=" + String.valueOf(this.rotation)).add("scale=" + String.valueOf(this.scale)).toString();
    }
}

