/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.entity.player.SpongeUserData;

public class SpongeUserInventory
implements Container {
    final NonNullList<ItemStack> mainInventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    final NonNullList<ItemStack> armorInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    final NonNullList<ItemStack> offHandInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories = Arrays.asList(this.mainInventory, this.armorInventory, this.offHandInventory);
    public int currentItem;
    private final SpongeUserData userData;
    private boolean dirty = false;

    public SpongeUserInventory(SpongeUserData userData) {
        this.userData = userData;
    }

    public ItemStack getCurrentItem() {
        return Inventory.isHotbarSlot((int)this.currentItem) ? (ItemStack)this.mainInventory.get(this.currentItem) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        this.setChanged();
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(index)).isEmpty() ? ContainerHelper.removeItem(list, (int)index, (int)count) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int index) {
        this.setChanged();
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(index)).isEmpty()) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(index);
            nonnulllist.set(index, (Object)ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int index, ItemStack stack) {
        this.setChanged();
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(index, (Object)stack);
        }
    }

    public ListTag writeList(ListTag nbtTagListIn) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).isEmpty()) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putByte("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).save((HolderLookup.Provider)SpongeCommon.server().registryAccess(), (Tag)nbttagcompound);
            nbtTagListIn.add((Object)nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (((ItemStack)this.armorInventory.get(j)).isEmpty()) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)(j + 100));
            ((ItemStack)this.armorInventory.get(j)).save((HolderLookup.Provider)SpongeCommon.server().registryAccess(), (Tag)nbttagcompound1);
            nbtTagListIn.add((Object)nbttagcompound1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (((ItemStack)this.offHandInventory.get(k)).isEmpty()) continue;
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.putByte("Slot", (byte)(k + 150));
            ((ItemStack)this.offHandInventory.get(k)).save((HolderLookup.Provider)SpongeCommon.server().registryAccess(), (Tag)nbttagcompound2);
            nbtTagListIn.add((Object)nbttagcompound2);
        }
        this.dirty = false;
        return nbtTagListIn;
    }

    public void readList(ListTag nbtTagListIn) {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundTag nbttagcompound = nbtTagListIn.getCompound(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = (ItemStack)ItemStack.parse((HolderLookup.Provider)SpongeCommon.server().registryAccess(), (Tag)nbttagcompound).get();
            if (itemstack.isEmpty()) continue;
            if (j >= 0 && j < this.mainInventory.size()) {
                this.mainInventory.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armorInventory.size() + 100) {
                this.armorInventory.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
            this.offHandInventory.set(j - 150, (Object)itemstack);
        }
    }

    public int getContainerSize() {
        return this.mainInventory.size() + this.armorInventory.size() + this.offHandInventory.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.mainInventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armorInventory) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offHandInventory) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(index);
    }

    public void setChanged() {
        this.dirty = true;
        this.userData.markDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }
}

