/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DeathMessageType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.event.cause.entity.damage.DamageEffect;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypeTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeDamageTypeTemplate
extends Record
implements DamageTypeTemplate {
    private final ResourceKey key;
    private final net.minecraft.world.damagesource.DamageType representedType;
    private final DataPack<DamageTypeTemplate> pack;

    public SpongeDamageTypeTemplate(ResourceKey key, net.minecraft.world.damagesource.DamageType representedType, DataPack<DamageTypeTemplate> pack) {
        this.key = key;
        this.representedType = representedType;
        this.pack = pack;
    }

    @Override
    public DamageType type() {
        return (DamageType)this.representedType;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeDamageTypeTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized DamageType:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(DamageTypeTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)net.minecraft.world.damagesource.DamageType.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)((net.minecraft.world.damagesource.DamageType)template.type())).getOrThrow();
    }

    public static net.minecraft.world.damagesource.DamageType decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (net.minecraft.world.damagesource.DamageType)net.minecraft.world.damagesource.DamageType.DIRECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static DamageTypeTemplate decode(DataPack<DamageTypeTemplate> pack, ResourceKey key, JsonElement packEntry, RegistryAccess registryAccess) {
        net.minecraft.world.damagesource.DamageType parsed = SpongeDamageTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeDamageTypeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeDamageTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeDamageTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeDamageTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public net.minecraft.world.damagesource.DamageType representedType() {
        return this.representedType;
    }

    @Override
    public DataPack<DamageTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<DamageType, DamageTypeTemplate, DamageTypeTemplate.Builder>
    implements DamageTypeTemplate.Builder {
        private String msgId;
        private DamageScaling scaling;
        private float exhaustion;
        private DamageEffects effects;
        private DeathMessageType deathMessageType;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public DamageTypeTemplate.Builder fromValue(DamageType value) {
            net.minecraft.world.damagesource.DamageType mcValue = (net.minecraft.world.damagesource.DamageType)value;
            this.msgId = mcValue.msgId();
            this.exhaustion = mcValue.exhaustion();
            this.scaling = mcValue.scaling();
            this.effects = mcValue.effects();
            this.deathMessageType = mcValue.deathMessageType();
            return this;
        }

        @Override
        public DamageTypeTemplate.Builder name(String name) {
            this.msgId = name;
            return this;
        }

        @Override
        public DamageTypeTemplate.Builder scaling(org.spongepowered.api.event.cause.entity.damage.DamageScaling scaling) {
            this.scaling = (DamageScaling)scaling;
            return this;
        }

        @Override
        public DamageTypeTemplate.Builder exhaustion(double exhaustion) {
            this.exhaustion = (float)exhaustion;
            return this;
        }

        @Override
        public DamageTypeTemplate.Builder effect(DamageEffect effect) {
            this.effects = (DamageEffects)effect;
            return this;
        }

        @Override
        public Function<DamageTypeTemplate, DamageType> valueExtractor() {
            return DamageTypeTemplate::type;
        }

        @Override
        public DamageTypeTemplate.Builder reset() {
            this.key = null;
            this.pack = DataPacks.DAMAGE_TYPE;
            this.msgId = null;
            this.scaling = DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            this.effects = DamageEffects.HURT;
            this.deathMessageType = DeathMessageType.DEFAULT;
            return this;
        }

        @Override
        public DamageTypeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
            net.minecraft.world.damagesource.DamageType damageType = SpongeDamageTypeTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((DamageType)damageType);
            return this;
        }

        @Override
        protected DamageTypeTemplate build0() {
            Objects.requireNonNull(this.msgId, "name");
            Objects.requireNonNull(this.scaling, "scaling");
            Objects.requireNonNull(this.effects, "effects");
            Objects.requireNonNull(this.deathMessageType, "deathMessageType");
            net.minecraft.world.damagesource.DamageType damageType = new net.minecraft.world.damagesource.DamageType(this.msgId, this.scaling, this.exhaustion, this.effects, this.deathMessageType);
            return new SpongeDamageTypeTemplate(this.key, damageType, this.pack);
        }
    }
}

