/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.VecHelper;

public class GrowablePhaseContext
extends PhaseContext<GrowablePhaseContext> {
    protected PhaseContext<?> priorContext;
    ItemStackSnapshot usedItem;
    Level world;
    BlockState blockState;
    BlockPos pos;
    SpongeBlockSnapshot snapshot;

    protected GrowablePhaseContext(IPhaseState<GrowablePhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public GrowablePhaseContext provideItem(ItemStack stack) {
        this.usedItem = ItemStackUtil.snapshotOf(stack);
        return this;
    }

    public GrowablePhaseContext world(Level worldIn) {
        this.world = worldIn;
        return this;
    }

    public GrowablePhaseContext block(BlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    public GrowablePhaseContext pos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public GrowablePhaseContext buildAndSwitch() {
        Preconditions.checkState(this.pos != null, "BlockPos is null");
        Preconditions.checkState(this.blockState != null, "BlockState is null");
        if (this.usedItem == null) {
            this.usedItem = ItemStackSnapshot.empty();
        }
        Preconditions.checkState(this.world != null, "World is null");
        this.priorContext = this.createdTracker.getPhaseContext();
        Preconditions.checkState(this.priorContext != null, "Prior context is null");
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().world((ServerLevel)this.world).position(VecHelper.toVector3i(this.pos)).blockState(this.blockState).flag(BlockChangeFlags.NONE.withPhysics(true).withUpdateNeighbors(true).withNotifyObservers(true));
        this.priorContext.applyOwnerIfAvailable(builder::creator);
        this.priorContext.applyNotifierIfAvailable(builder::notifier);
        this.snapshot = builder.build();
        return (GrowablePhaseContext)super.buildAndSwitch();
    }

    @Override
    protected void reset() {
        super.reset();
        this.priorContext = null;
        this.usedItem = null;
        this.world = null;
        this.blockState = null;
        this.pos = null;
        this.snapshot = null;
    }

    @Override
    protected GrowablePhaseContext defensiveCopy(PhaseTracker tracker) {
        GrowablePhaseContext newCopy = (GrowablePhaseContext)super.defensiveCopy(tracker);
        return newCopy;
    }
}

