/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.util.PrettyPrinter;

public class PlayerCommandPhaseContext
extends PacketContext<PlayerCommandPhaseContext> {
    @Nullable String command;
    private @Nullable TrackedInventoryBridge inventory;

    PlayerCommandPhaseContext(PacketState<PlayerCommandPhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    @Override
    public boolean hasCaptures() {
        return this.inventory != null && !this.inventory.bridge$getCapturedSlotTransactions().isEmpty() || super.hasCaptures();
    }

    @Override
    protected void reset() {
        super.reset();
        this.command = null;
        this.inventory = null;
    }

    public PlayerCommandPhaseContext command(String command) {
        this.command = command;
        return this;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "Command", this.command == null ? "empty command" : this.command);
        if (this.inventory != null) {
            printer.add(s + "-%s: %s", "Inventory", this.inventory.bridge$getCapturedSlotTransactions());
        }
        return printer;
    }

    public PlayerCommandPhaseContext inventory(TrackedInventoryBridge inventory) {
        this.inventory = inventory;
        return this;
    }
}

