/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class SlotCollection {
    private Inventory parent;
    private final Fabric fabric;
    private final List<Slot> slots;

    private SlotCollection(Inventory parent, Fabric fabric, Lens lens, SlotLensProvider slots) {
        this.parent = parent;
        this.fabric = fabric;
        this.slots = this.traverseSpanningTree(fabric, lens, (ImmutableList.Builder<Slot>)ImmutableList.builder()).build();
    }

    private ImmutableList.Builder<Slot> traverseSpanningTree(Fabric fabric, Lens lens, ImmutableList.Builder<Slot> list) {
        if (lens instanceof SlotLens) {
            list.add((Object)((SlotAdapter)lens.getAdapter(fabric, this.parent)));
            return list;
        }
        for (Lens child : lens.getSpanningChildren()) {
            if (child instanceof SlotLens) {
                list.add((Object)((SlotAdapter)child.getAdapter(fabric, this.parent)));
                continue;
            }
            if (child.getSpanningChildren().size() <= 0) continue;
            if (child instanceof DelegatingLens) {
                this.traverseSpanningTree(fabric.fabric$offset(child.base()), child, list);
                continue;
            }
            this.traverseSpanningTree(fabric, child, list);
        }
        return list;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public List<Slot> slots() {
        return this.slots;
    }

    public static SlotCollection of(Inventory parent, InventoryAdapter adapter) {
        return new SlotCollection(parent, adapter.inventoryAdapter$getFabric(), adapter.inventoryAdapter$getRootLens(), adapter.inventoryAdapter$getSlotLensProvider());
    }
}

