/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.query.SpongeQuery;

public abstract class SpongeDepthQuery
extends SpongeQuery {
    public abstract boolean matches(Lens var1, Lens var2, Inventory var3);

    @Override
    public Inventory execute(Inventory inventory, InventoryAdapter adapter) {
        Fabric fabric = adapter.inventoryAdapter$getFabric();
        Lens lens = adapter.inventoryAdapter$getRootLens();
        if (this.matches(lens, null, inventory)) {
            return lens.getAdapter(fabric, inventory);
        }
        return this.toResult(inventory, fabric, this.reduce(fabric, lens, this.depthFirstSearch(inventory, lens)));
    }

    private Map<Lens, Integer> depthFirstSearch(Inventory inventory, Lens lens) {
        LinkedHashMap<Lens, Integer> matches = new LinkedHashMap<Lens, Integer>();
        for (Lens child : lens.getChildren()) {
            if (child == null) continue;
            if (!child.getChildren().isEmpty()) {
                matches.putAll(this.depthFirstSearch(inventory, child));
            }
            if (!this.matches(child, lens, inventory)) continue;
            matches.put(child, 0);
        }
        if (lens.base() != 0 && !matches.isEmpty() && lens instanceof DelegatingLens) {
            matches.entrySet().forEach(entry -> entry.setValue((Integer)entry.getValue() + lens.base()));
        }
        return matches;
    }
}

