/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.item.ItemStackDataComponentsUpdater;
import org.spongepowered.common.item.ItemStackSnapshotDuplicateManipulatorUpdater;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongeItemStack {
    public static final ImmutableList<DataContentUpdater> STACK_UPDATERS = ImmutableList.of((Object)ItemStackSnapshotDuplicateManipulatorUpdater.INSTANCE, (Object)ItemStackDataComponentsUpdater.INSTANCE);

    @NotNull
    public static DataContainer getDataContainer(ItemStack mcStack) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)mcStack.getItem());
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, ((org.spongepowered.api.item.inventory.ItemStack)mcStack).contentVersion()).set(Constants.ItemStack.TYPE, key).set(Constants.ItemStack.COUNT, mcStack.getCount());
        SpongeItemStack.cleanupOldCustomData(mcStack);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)SpongeCommon.server().registryAccess());
        DataResult componentsTag = DataComponentPatch.CODEC.encodeStart((DynamicOps)ops, (Object)mcStack.getComponentsPatch());
        DataContainer components = NBTTranslator.INSTANCE.translate((CompoundTag)componentsTag.getOrThrow());
        container.set(Constants.ItemStack.COMPONENTS, components);
        return container;
    }

    @NotNull
    public static EquipmentSlotGroup asEquipmentSlotGroup(EquipmentType equipmentType) {
        return switch ((EquipmentSlot)equipmentType) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> EquipmentSlotGroup.MAINHAND;
            case EquipmentSlot.OFFHAND -> EquipmentSlotGroup.OFFHAND;
            case EquipmentSlot.FEET -> EquipmentSlotGroup.FEET;
            case EquipmentSlot.LEGS -> EquipmentSlotGroup.LEGS;
            case EquipmentSlot.CHEST -> EquipmentSlotGroup.CHEST;
            case EquipmentSlot.HEAD -> EquipmentSlotGroup.HEAD;
            case EquipmentSlot.BODY -> EquipmentSlotGroup.BODY;
        };
    }

    private static void cleanupOldCustomData(ItemStack stack) {
        CompoundTag unsafe = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe();
        unsafe.remove("SpongeData");
        Constants.NBT.filterSpongeCustomData(unsafe);
    }

    @NotNull
    public static Optional<org.spongepowered.api.item.inventory.ItemStack> createItemStack(DataView container) {
        Objects.requireNonNull(container);
        Integer version = container.getInt(Queries.CONTENT_VERSION).orElse(1);
        ImmutableList.Builder builder = ImmutableList.builder();
        int lastUpdaterVersion = version;
        for (DataContentUpdater updater : STACK_UPDATERS) {
            if (lastUpdaterVersion != updater.inputVersion()) continue;
            lastUpdaterVersion = updater.outputVersion();
            builder.add((Object)updater);
        }
        DataUpdaterDelegate delegate = new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), version, 3);
        DataView updatedContainer = delegate.update(container);
        if (!updatedContainer.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
            return Optional.empty();
        }
        int count = updatedContainer.getInt(Constants.ItemStack.COUNT).get();
        ItemType itemType = updatedContainer.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE).orElseThrow(() -> new IllegalStateException("Unable to find item with id: "));
        ItemStack mcStack = new ItemStack((ItemLike)((Item)itemType), count);
        if (!mcStack.isEmpty()) {
            mcStack.applyComponents(SpongeItemStack.patchFromData(updatedContainer));
        }
        return Optional.of((org.spongepowered.api.item.inventory.ItemStack)mcStack);
    }

    public static DataComponentPatch patchFromData(DataView container) {
        return container.getView(Constants.ItemStack.COMPONENTS).map(NBTTranslator.INSTANCE::translate).flatMap(compound -> {
            Dynamic dynamic = new Dynamic((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)SpongeCommon.server().registryAccess()), compound);
            return DataComponentPatch.CODEC.decode(dynamic).result().map(Pair::getFirst);
        }).orElse(DataComponentPatch.EMPTY);
    }

    public static final class FactoryImpl
    implements ItemStack.Factory {
        @Override
        public org.spongepowered.api.item.inventory.ItemStack empty() {
            return (org.spongepowered.api.item.inventory.ItemStack)ItemStack.EMPTY;
        }
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<org.spongepowered.api.item.inventory.ItemStack>
    implements ItemStack.Builder {
        private ItemType type;
        private int quantity;
        private @Nullable LinkedHashMap<Key<?>, Object> keyValues;
        private DataComponentPatch components = DataComponentPatch.EMPTY;

        public BuilderImpl() {
            super(org.spongepowered.api.item.inventory.ItemStack.class, 1);
            this.reset();
        }

        @Override
        public ItemStack.Builder itemType(ItemType itemType) {
            Objects.requireNonNull(itemType, "Item type cannot be null");
            this.type = itemType;
            return this;
        }

        @Override
        public ItemType currentItem() {
            return this.type == null ? BlockTypes.AIR.get().item().get() : this.type;
        }

        @Override
        public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
            Preconditions.checkArgument(quantity >= 0, "Quantity must not be smaller than 0");
            this.quantity = quantity;
            return this;
        }

        @Override
        public <V> ItemStack.Builder add(Key<? extends Value<V>> key, V value) throws IllegalArgumentException {
            if (this.keyValues == null) {
                this.keyValues = new LinkedHashMap();
            }
            this.keyValues.put(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
            return this;
        }

        @Override
        public ItemStack.Builder fromItemStack(org.spongepowered.api.item.inventory.ItemStack itemStack) {
            Objects.requireNonNull(itemStack, "Item stack cannot be null");
            this.type = itemStack.type();
            this.quantity = itemStack.quantity();
            org.spongepowered.api.item.inventory.ItemStack itemStack2 = itemStack;
            if (itemStack2 instanceof ItemStack) {
                ItemStack mcStack = (ItemStack)itemStack2;
                this.components = mcStack.getComponentsPatch();
            }
            return this;
        }

        @Override
        public ItemStack.Builder attributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
            Objects.requireNonNull(attributeType, "AttributeType cannot be null");
            Objects.requireNonNull(modifier, "AttributeModifier cannot be null");
            Objects.requireNonNull(equipmentType, "EquipmentType cannot be null");
            Optional<ItemAttributeModifiers> existing = this.components.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (existing == null) {
                existing = Optional.empty();
            }
            ItemAttributeModifiers modifiers = existing.map(ItemAttributeModifiers.class::cast).orElse(ItemAttributeModifiers.EMPTY);
            Holder attribute = BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)((Attribute)attributeType));
            EquipmentSlotGroup slotGroup = SpongeItemStack.asEquipmentSlotGroup(equipmentType);
            modifiers = modifiers.withModifierAdded(attribute, (net.minecraft.world.entity.ai.attributes.AttributeModifier)modifier, slotGroup);
            DataComponentPatch.Builder builder = DataComponentPatch.builder();
            this.components.entrySet().forEach(entry -> builder.set((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElse(null)));
            builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
            this.components = builder.build();
            return this;
        }

        @Override
        public ItemStack.Builder fromContainer(DataView container) {
            Optional<org.spongepowered.api.item.inventory.ItemStack> stack = SpongeItemStack.createItemStack(container);
            if (stack.isPresent()) {
                this.reset();
                return this.fromItemStack(stack.get());
            }
            SpongeCommon.logger().warn("Invalid ItemStack Container");
            return this;
        }

        @Override
        public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
            Objects.requireNonNull(snapshot, "The snapshot was null!");
            this.itemType(snapshot.type());
            this.quantity(snapshot.quantity());
            for (Value.Immutable value : snapshot.getValues()) {
                this.add(value);
            }
            if (snapshot instanceof SpongeItemStackSnapshot) {
                this.components = ((SpongeItemStackSnapshot)snapshot).getComponentsPatch();
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
            Objects.requireNonNull(blockSnapshot, "The snapshot was null!");
            this.reset();
            BlockType blockType = blockSnapshot.state().type();
            ResourceLocation blockTypeKey = SpongeCommon.vanillaRegistry(Registries.BLOCK).getKey((Object)((Block)blockType));
            Optional<ItemType> itemType = blockType.item();
            this.itemType(itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + String.valueOf(blockTypeKey))));
            this.quantity(1);
            if (blockSnapshot instanceof SpongeBlockSnapshot) {
                ((SpongeBlockSnapshot)blockSnapshot).getCompound().ifPresent(compoundTag -> {
                    this.components = DataComponentPatch.builder().set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundTag)).build();
                });
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockState(BlockState blockState) {
            Objects.requireNonNull(blockState, "blockState");
            BlockType blockType = blockState.type();
            ResourceLocation blockTypeKey = SpongeCommon.vanillaRegistry(Registries.BLOCK).getKey((Object)((Block)blockType));
            this.itemType(blockType.item().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + String.valueOf(blockTypeKey))));
            blockState.getValues().forEach(this::add);
            return this;
        }

        @Override
        public ItemStack.Builder from(org.spongepowered.api.item.inventory.ItemStack value) {
            return this.fromItemStack(value);
        }

        @Override
        protected Optional<org.spongepowered.api.item.inventory.ItemStack> buildContent(DataView container) throws InvalidDataException {
            return SpongeItemStack.createItemStack(container);
        }

        @Override
        public ItemStack.Builder reset() {
            this.type = null;
            this.quantity = 1;
            this.components = DataComponentPatch.EMPTY;
            return this;
        }

        @Override
        public org.spongepowered.api.item.inventory.ItemStack build() throws IllegalStateException {
            Preconditions.checkState(this.type != null, "Item type has not been set");
            if (this.type == null || this.quantity <= 0) {
                return (org.spongepowered.api.item.inventory.ItemStack)ItemStack.EMPTY;
            }
            ItemStack mcStack = new ItemStack((ItemLike)((Item)this.type), this.quantity);
            mcStack.applyComponents(this.components);
            org.spongepowered.api.item.inventory.ItemStack stack = (org.spongepowered.api.item.inventory.ItemStack)mcStack;
            if (this.keyValues != null) {
                this.keyValues.forEach((key, value) -> stack.offer(key, value));
            }
            return stack;
        }
    }
}

