/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessRecipe;

public class SpongeShapelessCraftingRecipeRegistration
extends SpongeRecipeRegistration<ShapelessRecipe>
implements SpongeRecipeRegistration.ResultFunctionRegistration<CraftingContainer>,
SpongeRecipeRegistration.RemainingItemsFunctionRegistration<CraftingContainer> {
    private final List<Ingredient> ingredients;
    private final ItemStack spongeResult;
    private final Function<CraftingContainer, ItemStack> resultFunction;
    private final Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;
    private final CraftingBookCategory craftingBookCategory;

    public SpongeShapelessCraftingRecipeRegistration(ResourceLocation key, String group, List<Ingredient> ingredients, ItemStack spongeResult, Function<CraftingContainer, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, DataPack<RecipeRegistration> pack, RecipeCategory category, CraftingBookCategory craftingBookCategory) {
        super(key, group, pack, category, RecipeSerializer.SHAPELESS_RECIPE);
        this.ingredients = ingredients;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
        this.craftingBookCategory = craftingBookCategory;
    }

    @Override
    public Function<CraftingContainer, ItemStack> resultFunction() {
        return this.resultFunction;
    }

    @Override
    public Function<CraftingContainer, NonNullList<ItemStack>> remainingItems() {
        return this.remainingItemsFunction;
    }

    @Override
    public Recipe recipe() {
        this.ensureCached();
        NonNullList ingredients = NonNullList.create();
        ingredients.addAll(this.ingredients);
        if (SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, this.remainingItemsFunction, (Collection<Ingredient>)ingredients)) {
            return (ShapelessCraftingRecipe)new ShapelessRecipe(this.group, this.craftingBookCategory, this.spongeResult, ingredients);
        }
        return (ShapelessCraftingRecipe)((Object)new SpongeShapelessRecipe(this.group, this.craftingBookCategory, (NonNullList<Ingredient>)ingredients, this.spongeResult, this.resultFunction == null ? null : this.key.toString(), this.remainingItemsFunction == null ? null : this.key.toString()));
    }
}

