/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.map;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={MapDecoration.class})
public abstract class MapDecorationMixin_API
implements org.spongepowered.api.map.decoration.MapDecoration {
    @Shadow
    @Final
    private Holder<net.minecraft.world.level.saveddata.maps.MapDecorationType> type;
    @Shadow
    @Final
    @Mutable
    private byte x;
    @Shadow
    @Final
    @Mutable
    private byte y;
    @Shadow
    @Final
    @Mutable
    private byte rot;
    @Shadow
    @Final
    private Optional<Component> name;

    @Override
    public MapDecorationType type() {
        return (MapDecorationType)this.type.value();
    }

    @Override
    public Vector2i position() {
        return new Vector2i((int)this.x, (int)this.y);
    }

    @Override
    public void setPosition(Vector2i position) {
        Preconditions.checkState(MapUtil.isInMapDecorationBounds(position.x()), "x position out of bounds");
        Preconditions.checkState(MapUtil.isInMapDecorationBounds(position.y()), "y position out of bounds");
        this.x = (byte)position.x();
        this.y = (byte)position.y();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public void setRotation(MapDecorationOrientation dir) {
        this.rot = (byte)((SpongeMapDecorationOrientation)dir).getOrientationNumber();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    @Override
    public MapDecorationOrientation rotation() {
        int rot = MapUtil.normalizeDecorationOrientation(this.rot);
        return MapUtil.getMapRotById(rot);
    }

    @Override
    public boolean isPersistent() {
        return ((MapDecorationBridge)((Object)this)).bridge$isPersistent();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer data = DataContainer.createNew().set(Constants.Map.DECORATION_TYPE, BuiltInRegistries.MAP_DECORATION_TYPE.getKey((Object)((net.minecraft.world.level.saveddata.maps.MapDecorationType)this.type.value()))).set(Constants.Map.DECORATION_ID, ((MapDecorationBridge)((Object)this)).bridge$getKey()).set(Constants.Map.DECORATION_X, this.x).set(Constants.Map.DECORATION_Y, this.y).set(Constants.Map.DECORATION_ROTATION, (byte)MapUtil.normalizeDecorationOrientation(this.rot));
        this.name.ifPresent(component -> data.set(Constants.Map.NAME, Component.Serializer.toJson((Component)component, (HolderLookup.Provider)SpongeCommon.server().registryAccess())));
        return data;
    }
}

