/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.generation.GenerationRegion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={WorldGenRegion.class})
public abstract class WorldGenRegionMixin_API
implements GenerationRegion {
    @Shadow
    @Final
    private ChunkPos firstPos;
    @Shadow
    @Final
    private ChunkPos lastPos;
    @Shadow
    @Final
    private ServerLevel level;
    private ResourceKey api$serverWorldKey;
    private @MonotonicNonNull Vector3i api$minBlock;
    private @MonotonicNonNull Vector3i api$maxBlock;
    private @MonotonicNonNull Vector3i api$size;

    @Shadow
    public abstract ChunkAccess shadow$getChunk(int var1, int var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void api$getWorldKeyOnConstruction(ServerLevel param0, List<ChunkAccess> param1, ChunkStatus param2, int param3, CallbackInfo ci) {
        this.api$serverWorldKey = (ResourceKey)param0.dimension().location();
    }

    @Override
    public @NonNull ResourceKey worldKey() {
        return this.api$serverWorldKey;
    }

    @Override
    public @NonNull Server engine() {
        return SpongeCommon.game().server();
    }

    @Override
    public @NonNull GenerationChunk chunk(int cx, int cy, int cz) {
        ChunkAccess chunk;
        try {
            chunk = this.shadow$getChunk(cx, cz);
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Chunk coordinates (%d, %d, %d) is out of bounds.", cx, cy, cz));
        }
        if (chunk instanceof LevelChunk) {
            return (GenerationChunk)new ImposterProtoChunk((LevelChunk)chunk, false);
        }
        return (GenerationChunk)chunk;
    }

    @Override
    public @NonNull Vector3i chunkMin() {
        return VecHelper.toVector3i(this.firstPos).min(VecHelper.toVector3i(this.lastPos));
    }

    @Override
    public @NonNull Vector3i chunkMax() {
        return VecHelper.toVector3i(this.firstPos).max(VecHelper.toVector3i(this.lastPos));
    }

    @Override
    public @NonNull Vector3i min() {
        if (this.api$minBlock == null) {
            this.api$minBlock = this.convertToBlock(this.chunkMin(), false);
        }
        return this.api$minBlock;
    }

    @Override
    public @NonNull Vector3i max() {
        if (this.api$maxBlock == null) {
            this.api$maxBlock = this.convertToBlock(this.chunkMax(), true);
        }
        return this.api$maxBlock;
    }

    @Override
    public @NonNull Vector3i size() {
        if (this.api$size == null) {
            this.api$size = this.max().sub(this.min()).add(Vector3i.ONE);
        }
        return this.api$size;
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    private Vector3i convertToBlock(Vector3i chunk, boolean isMax) {
        SpongeChunkLayout layout = (SpongeChunkLayout)((ServerWorld)this.level).chunkLayout();
        Vector3i chunkMin = layout.forceToWorld(chunk);
        if (isMax) {
            return chunkMin.add(layout.getMask());
        }
        return chunkMin;
    }
}

