/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.packs.resources;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.resource.Resource;
import org.spongepowered.api.resource.ResourcePath;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.resource.SpongeResource;
import org.spongepowered.common.resource.SpongeResourcePath;

@Mixin(value={ResourceManager.class})
public interface ResourceManagerMixin_API
extends org.spongepowered.api.resource.ResourceManager {
    @Shadow
    public List<net.minecraft.server.packs.resources.Resource> shadow$getResourceStack(ResourceLocation var1);

    @Shadow
    public Map<ResourceLocation, net.minecraft.server.packs.resources.Resource> shadow$listResources(String var1, Predicate<ResourceLocation> var2);

    @Override
    default public Resource load(ResourcePath path) throws IOException {
        ResourceLocation loc = (ResourceLocation)Objects.requireNonNull(path, "path").key();
        net.minecraft.server.packs.resources.Resource resource = ((ResourceProvider)this).getResourceOrThrow(loc);
        return new SpongeResource(resource, path);
    }

    @Override
    default public Stream<Resource> streamAll(ResourcePath path) {
        ResourceLocation loc = (ResourceLocation)Objects.requireNonNull(path, "path").key();
        return this.shadow$getResourceStack(loc).stream();
    }

    @Override
    default public Collection<ResourcePath> find(String pathPrefix, Predicate<String> pathFilter) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(pathFilter, "pathFilter");
        Set<ResourceLocation> mapped = this.shadow$listResources(pathPrefix, loc -> pathFilter.test(loc.getPath())).keySet();
        return mapped.stream().map(r -> new SpongeResourcePath((ResourceKey)r)).collect(Collectors.toList());
    }
}

