/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity.ai.goal;

import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import org.spongepowered.api.entity.ai.goal.builtin.creature.RangedAttackAgainstAgentGoal;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.SpongeTicks;

@Mixin(value={RangedAttackGoal.class})
public abstract class RangedAttackGoalMixin_API
implements RangedAttackAgainstAgentGoal {
    @Shadow
    @Final
    @Mutable
    private double speedModifier;
    @Shadow
    @Final
    @Mutable
    private int attackIntervalMax;
    @Shadow
    @Final
    @Mutable
    private float attackRadius;
    @Shadow
    @Final
    @Mutable
    private float attackRadiusSqr;

    @Override
    public double moveSpeed() {
        return this.speedModifier;
    }

    @Override
    public RangedAttackAgainstAgentGoal setMoveSpeed(double speed) {
        this.speedModifier = speed;
        return this;
    }

    @Override
    public Ticks delayBetweenAttacks() {
        return Ticks.of(this.attackIntervalMax);
    }

    @Override
    public RangedAttackAgainstAgentGoal setDelayBetweenAttacks(Ticks delay) {
        this.attackIntervalMax = SpongeTicks.toSaturatedIntOrInfinite(delay, -2);
        return this;
    }

    @Override
    public float attackRadius() {
        return this.attackRadius;
    }

    @Override
    public RangedAttackAgainstAgentGoal setAttackRadius(float radius) {
        this.attackRadius = radius;
        this.attackRadiusSqr = this.attackRadius * this.attackRadius;
        return this;
    }
}

