/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item.component;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.world.item.component.FireworkExplosion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.Constants;

@Mixin(value={FireworkExplosion.class})
public abstract class FireworkExplosionMixin_API
implements FireworkEffect {
    @Shadow
    @Final
    private boolean hasTwinkle;
    @Shadow
    @Final
    private boolean hasTrail;
    @Shadow
    @Final
    private IntList colors;
    @Shadow
    @Final
    private IntList fadeColors;
    @Shadow
    @Final
    private FireworkExplosion.Shape shape;

    @Override
    public boolean flickers() {
        return this.hasTwinkle;
    }

    @Override
    public boolean hasTrail() {
        return this.hasTrail;
    }

    @Override
    public List<Color> colors() {
        return this.colors.intStream().mapToObj(Color::ofRgb).toList();
    }

    @Override
    public List<Color> fadeColors() {
        return this.fadeColors.intStream().mapToObj(Color::ofRgb).toList();
    }

    @Override
    public FireworkShape shape() {
        return (FireworkShape)this.shape;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.FIREWORK_SHAPE).valueKey((FireworkShape)this.shape);
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Item.Fireworks.FIREWORK_SHAPE, resourceKey).set(Constants.Item.Fireworks.FIREWORK_COLORS, this.colors).set(Constants.Item.Fireworks.FIREWORK_FADE_COLORS, this.fadeColors()).set(Constants.Item.Fireworks.FIREWORK_TRAILS, this.hasTrail).set(Constants.Item.Fireworks.FIREWORK_FLICKERS, this.hasTwinkle);
    }
}

