/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item.crafting;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeManager;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.inventory.CraftingMenuAccessor;
import org.spongepowered.common.accessor.world.inventory.InventoryMenuAccessor;
import org.spongepowered.common.accessor.world.level.block.entity.AbstractFurnaceBlockEntityAccessor;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={net.minecraft.world.item.crafting.RecipeManager.class})
public abstract class RecipeManagerMixin_API
implements RecipeManager {
    @Shadow
    public abstract Optional<? extends Recipe<?>> shadow$byKey(ResourceLocation var1);

    @Shadow
    protected abstract <C extends Container, T extends Recipe<C>> Collection<RecipeHolder<T>> shadow$byType(net.minecraft.world.item.crafting.RecipeType<T> var1);

    @Shadow
    public abstract Collection<Recipe<?>> shadow$getRecipes();

    @Shadow
    public abstract <C extends Container, T extends Recipe<C>> Optional<T> shadow$getRecipeFor(net.minecraft.world.item.crafting.RecipeType<T> var1, C var2, Level var3);

    @Override
    public Optional<org.spongepowered.api.item.recipe.Recipe> byKey(ResourceKey key) {
        Objects.requireNonNull(key);
        return this.shadow$byKey((ResourceLocation)key).map(org.spongepowered.api.item.recipe.Recipe.class::cast);
    }

    @Override
    public Collection<org.spongepowered.api.item.recipe.Recipe> all() {
        return this.shadow$getRecipes();
    }

    @Override
    public <T extends org.spongepowered.api.item.recipe.Recipe> Collection<T> allOfType(RecipeType<T> type) {
        Objects.requireNonNull(type);
        return this.shadow$byType((net.minecraft.world.item.crafting.RecipeType)type);
    }

    @Override
    public <T extends org.spongepowered.api.item.recipe.Recipe> Collection<T> findByResult(RecipeType<T> type, ItemStackSnapshot result) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(result);
        return this.allOfType(type).stream().filter(r -> r.exemplaryResult().equals(result)).collect(Collectors.toList());
    }

    @Override
    public Optional<org.spongepowered.api.item.recipe.Recipe> findMatchingRecipe(Inventory inventory, ServerWorld world) {
        Objects.requireNonNull(inventory);
        Objects.requireNonNull(world);
        if (inventory instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)inventory;
            Optional<AbstractCookingRecipe> recipeFor = ((AbstractFurnaceBlockEntityAccessor)((Object)inventory)).accessor$quickCheck().getRecipeFor((Container)furnace, furnace.getLevel()).map(RecipeHolder::value);
            return recipeFor.map(org.spongepowered.api.item.recipe.Recipe.class::cast);
        }
        if (inventory instanceof CampfireBlockEntity) {
            return this.shadow$getRecipeFor(net.minecraft.world.item.crafting.RecipeType.CAMPFIRE_COOKING, (Container)inventory, (Level)world).map(org.spongepowered.api.item.recipe.Recipe.class::cast);
        }
        if (inventory instanceof CraftingMenu) {
            CraftingContainer craftingInventory = ((CraftingMenuAccessor)((Object)inventory)).accessor$craftSlots();
            return this.shadow$getRecipeFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING, craftingInventory, (Level)world).map(org.spongepowered.api.item.recipe.Recipe.class::cast);
        }
        if (inventory instanceof InventoryMenu) {
            CraftingContainer craftingInventory = ((InventoryMenuAccessor)((Object)inventory)).accessor$craftSlots();
            return this.shadow$getRecipeFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING, craftingInventory, (Level)world).map(org.spongepowered.api.item.recipe.Recipe.class::cast);
        }
        if (inventory instanceof StonecutterMenu) {
            Container stonecutterInventory = ((StonecutterMenu)inventory).container;
            return this.shadow$getRecipeFor(net.minecraft.world.item.crafting.RecipeType.STONECUTTING, stonecutterInventory, (Level)world).map(org.spongepowered.api.item.recipe.Recipe.class::cast);
        }
        return Optional.empty();
    }

    @Override
    public <T extends org.spongepowered.api.item.recipe.Recipe> Optional<T> findMatchingRecipe(RecipeType<T> type, Inventory inventory, ServerWorld world) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(inventory);
        Objects.requireNonNull(world);
        if (!(inventory instanceof Container)) {
            return Optional.empty();
        }
        return this.shadow$getRecipeFor((net.minecraft.world.item.crafting.RecipeType)type, (Container)inventory, (Level)world);
    }

    @Override
    public <T extends CookingRecipe> Optional<T> findCookingRecipe(RecipeType<T> type, ItemStackSnapshot ingredient) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(ingredient);
        SimpleContainer fakeFurnace = new SimpleContainer(1);
        fakeFurnace.setItem(0, ItemStackUtil.fromSnapshotToNative(ingredient));
        return this.shadow$getRecipeFor((net.minecraft.world.item.crafting.RecipeType)type, fakeFurnace, null);
    }
}

