/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={LevelReader.class})
public interface LevelReaderMixin_API<R extends Region<R>>
extends Region<R> {
    @Shadow
    public @Nullable ChunkAccess shadow$getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    @Shadow
    public boolean shadow$hasChunk(int var1, int var2);

    @Shadow
    public int shadow$getHeight(Heightmap.Types var1, int var2, int var3);

    @Shadow
    public int shadow$getSkyDarken();

    @Shadow
    public int shadow$getSeaLevel();

    @Shadow
    public boolean shadow$isWaterAt(BlockPos var1);

    @Deprecated
    @Shadow
    public boolean shadow$hasChunksAt(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public DimensionType shadow$dimensionType();

    @Shadow
    public boolean shadow$containsAnyLiquid(AABB var1);

    @Shadow
    public Holder<Biome> shadow$getBiome(BlockPos var1);

    @Shadow
    public RegistryAccess shadow$registryAccess();

    @Override
    default public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of(PaletteTypes.BLOCK_STATE_PALETTE.get(), Block.BLOCK_STATE_REGISTRY, (Registry)this.shadow$registryAccess().registryOrThrow(Registries.BLOCK));
    }

    @Override
    default public WorldType worldType() {
        return (WorldType)this.shadow$dimensionType();
    }

    @Override
    default public WorldBorder border() {
        return ((WorldBorderBridge)((CollisionGetter)this).getWorldBorder()).bridge$asImmutable();
    }

    @Override
    default public WorldBorder setBorder(WorldBorder border) {
        WorldBorder worldBorder = ((WorldBorderBridge)((CollisionGetter)this).getWorldBorder()).bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)net.minecraft.world.level.border.WorldBorder.DEFAULT_SETTINGS;
        }
        return worldBorder;
    }

    @Override
    default public boolean isInBorder(Entity entity) {
        return ((CollisionGetter)this).getWorldBorder().isWithinBounds(((net.minecraft.world.entity.Entity)Objects.requireNonNull(entity, "entity")).getBoundingBox());
    }

    @Override
    default public boolean canSeeSky(int x, int y, int z) {
        return ((BlockAndTintGetter)this).canSeeSky(new BlockPos(x, y, z));
    }

    @Override
    default public boolean hasLiquid(int x, int y, int z) {
        return this.shadow$isWaterAt(new BlockPos(x, y, z));
    }

    @Override
    default public boolean containsAnyLiquids(org.spongepowered.api.util.AABB aabb) {
        Vector3d max = Objects.requireNonNull(aabb, "aabb").max();
        Vector3d min = aabb.min();
        return this.shadow$containsAnyLiquid(new AABB(min.x(), min.y(), min.z(), max.x(), max.y(), max.z()));
    }

    @Override
    default public int skylightSubtracted() {
        return this.shadow$getSkyDarken();
    }

    @Override
    default public int seaLevel() {
        return this.shadow$getSeaLevel();
    }

    @Override
    default public boolean isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.shadow$hasChunksAt(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    @Override
    default public RandomProvider.Source random() {
        return (RandomProvider.Source)RandomSource.create();
    }

    default public Chunk<@NonNull ?> chunk(int x, int y, int z) {
        return (Chunk)this.shadow$getChunk(x, z, ChunkStatus.EMPTY, true);
    }

    @Override
    default public boolean isChunkLoaded(int cx, int cy, int cz, boolean allowEmpty) {
        return this.shadow$hasChunk(cx, cz);
    }

    @Override
    default public boolean hasChunk(int cx, int cy, int cz) {
        return this.shadow$hasChunk(cx, cz);
    }

    @Override
    default public int height(HeightType type, int x, int z) {
        return this.shadow$getHeight((Heightmap.Types)Objects.requireNonNull(type, "type"), x, z);
    }

    @Override
    default public org.spongepowered.api.world.biome.Biome biome(int x, int y, int z) {
        return (org.spongepowered.api.world.biome.Biome)this.shadow$getBiome(new BlockPos(x, y, z)).value();
    }

    @Override
    default public VolumeStream<R, org.spongepowered.api.world.biome.Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBiomeStream((LevelReader)this, min, max, options);
    }

    @Override
    default public VolumeStream<R, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.generateBlockStream((LevelReader)this, min, max, options);
    }

    @Override
    default public VolumeStream<R, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBlockEntityStream((LevelReader)this, min, max, options);
    }
}

