/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.chunk.ChunkState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkAccess.class})
public abstract class ChunkAccessMixin_API<P extends Chunk<P>>
implements Chunk<P>,
LevelHeightAccessor {
    @Shadow
    public abstract ChunkStatus shadow$getStatus();

    @Shadow
    public abstract void shadow$addEntity(net.minecraft.world.entity.Entity var1);

    @Shadow
    public abstract void shadow$setInhabitedTime(long var1);

    @Shadow
    public abstract long shadow$getInhabitedTime();

    @Shadow
    public abstract ChunkPos shadow$getPos();

    @Shadow
    public abstract int shadow$getHeight(Heightmap.Types var1, int var2, int var3);

    @Shadow
    public abstract LevelChunkSection shadow$getSection(int var1);

    @Shadow
    public abstract void shadow$setUnsaved(boolean var1);

    @Override
    public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of(PaletteTypes.BLOCK_STATE_PALETTE.get(), Block.BLOCK_STATE_REGISTRY, (Registry)Registries.BLOCK);
    }

    @Override
    public void addEntity(Entity entity) {
        this.shadow$addEntity((net.minecraft.world.entity.Entity)entity);
    }

    @Override
    public ChunkState state() {
        return (ChunkState)this.shadow$getStatus();
    }

    @Override
    public boolean isEmpty() {
        return this.shadow$getStatus() == ChunkStatus.EMPTY;
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> this.shadow$getSection(this.getSectionIndex(y)), () -> this.shadow$setUnsaved(true));
    }

    @Override
    public Ticks inhabitedTime() {
        return new SpongeTicks(this.shadow$getInhabitedTime());
    }

    @Override
    public void setInhabitedTime(Ticks newInhabitedTime) {
        Objects.requireNonNull(newInhabitedTime);
        if (newInhabitedTime.isInfinite()) {
            throw new IllegalArgumentException("Inhabited time cannot be infinite!");
        }
        this.shadow$setInhabitedTime(newInhabitedTime.ticks());
    }

    @Override
    public Vector3i chunkPosition() {
        ChunkPos chunkPos = this.shadow$getPos();
        return new Vector3i(chunkPos.x, 0, chunkPos.z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.shadow$getHeight((Heightmap.Types)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    public int height(HeightType type, int x, int z) {
        return this.shadow$getHeight((Heightmap.Types)Objects.requireNonNull(type, "type"), x, z);
    }

    @Override
    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledBlockUpdates");
    }

    @Override
    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledFluidUpdates");
    }
}

