/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterion;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.CriterionBridge;
import org.spongepowered.common.bridge.advancements.CriterionProgressBridge;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Preconditions;

@Mixin(value={AdvancementProgress.class})
public abstract class AdvancementProgressMixin
implements AdvancementProgressBridge {
    @Shadow
    @Final
    private Map<String, net.minecraft.advancements.CriterionProgress> criteria;
    private @Nullable Map<String, ImplementationBackedCriterionProgress> impl$progressMap;
    private @Nullable ResourceLocation impl$advancementKey;
    private @Nullable PlayerAdvancements impl$playerAdvancements;

    @Override
    public Advancement bridge$getAdvancement() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        AdvancementHolder advancement = SpongeCommon.server().getAdvancements().get(this.impl$advancementKey);
        if (advancement == null) {
            throw new IllegalStateException("The advancement of this advancement progress is unloaded: " + String.valueOf(this.impl$advancementKey));
        }
        return (Advancement)advancement.value();
    }

    @Override
    public ResourceLocation bridge$getAdvancementKey() {
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        return this.impl$advancementKey;
    }

    @Override
    public PlayerAdvancements bridge$getPlayerAdvancements() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$playerAdvancements != null, "The playerAdvancements is not yet initialized");
        return this.impl$playerAdvancements;
    }

    @Override
    public void bridge$setPlayerAdvancements(PlayerAdvancements playerAdvancements) {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$playerAdvancements = playerAdvancements;
    }

    @Override
    public void bridge$setAdvancementId(ResourceLocation key) {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$advancementKey = key;
    }

    @Override
    public void bridge$invalidateAchievedState() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        for (ImplementationBackedCriterionProgress progress : this.impl$getProgressMap().values()) {
            progress.invalidateAchievedState();
        }
    }

    @Override
    public void bridge$updateProgressMap() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Optional<Advancement> advancement = this.impl$getOptionalAdvancement();
        if (advancement.isPresent()) {
            this.impl$progressMap = new LinkedHashMap<String, ImplementationBackedCriterionProgress>();
            if (advancement.get().criterion() != null) {
                this.impl$processProgressMap(advancement.get().criterion(), this.impl$progressMap);
            } else {
                SpongeCommon.logger().warn("advancement has null criterion");
            }
        } else {
            this.impl$progressMap = null;
        }
    }

    @Override
    public Map<String, ImplementationBackedCriterionProgress> bridge$getProgressMap() {
        return this.impl$progressMap;
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void impl$updateCriterionsAndMap(AdvancementRequirements requirements, CallbackInfo ci) {
        for (List reqs : requirements.requirements()) {
            for (String req : reqs) {
                if (this.criteria.containsKey(req)) continue;
                String advName = this.impl$getOptionalAdvancement().map(Objects::toString).orElse("unknown");
                throw new IllegalStateException("Found a requirement which does not exist in the criteria, " + req + " could not be found for the advancement: " + advName);
            }
        }
        this.bridge$updateProgressMap();
    }

    private Map<String, ImplementationBackedCriterionProgress> impl$getProgressMap() {
        Preconditions.checkState(this.impl$progressMap != null, "progressMap isn't initialized");
        return this.impl$progressMap;
    }

    private void impl$processProgressMap(AdvancementCriterion criterion, Map<String, ImplementationBackedCriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).criteria().forEach(child -> this.impl$processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion.name(), new SpongeAndCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion.name(), new SpongeOrCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                CriterionProgressBridge progress = (CriterionProgressBridge)this.criteria.get(advancementCriterion.name());
                progress.bridge$setCriterion(advancementCriterion);
                progress.bridge$setAdvancementProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this));
                progressMap.put(advancementCriterion.name(), (ImplementationBackedCriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion.name(), new SpongeScoreCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), scoreCriterion));
        } else if (!(criterion instanceof SpongeEmptyCriterion)) {
            CriterionProgressBridge progress = (CriterionProgressBridge)this.criteria.get(criterion.name());
            progress.bridge$setCriterion(criterion);
            progress.bridge$setAdvancementProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this));
            progressMap.put(criterion.name(), (ImplementationBackedCriterionProgress)((Object)progress));
        }
    }

    @Inject(method={"isDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$supportComplexCriteria(CallbackInfoReturnable<Boolean> ci) {
        if (this.impl$advancementKey == null || !PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Advancement advancement = this.impl$getOptionalAdvancement().orElse(null);
        if (advancement != null) {
            if (advancement.criterion() != null) {
                ImplementationBackedCriterionProgress bridge = this.impl$progressMap.get(advancement.criterion().name());
                ci.setReturnValue((Object)(bridge != null && ((CriterionProgress)((Object)bridge)).achieved() ? 1 : 0));
            } else {
                SpongeCommon.logger().warn("advancement has null criterion");
            }
        }
    }

    @Inject(method={"grantProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$grantScoreCriteriaAndCallEvents(String criterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$grantCriterion(criterion));
    }

    private boolean impl$grantCriterion(String rawCriterion) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.criteria.get(rawCriterion);
        if (criterionProgress == null || criterionProgress.isDone()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.grant();
            return true;
        }
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.criterion();
        CriterionBridge criterionBridge = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.name());
            int lastScore = scoreProgress.score();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.bridge$getAdvancement(), (ResourceKey)this.impl$advancementKey, scoreCriterion, player, lastScore, score) : (score == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.bridge$getAdvancement(), (ResourceKey)this.impl$advancementKey, scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.bridge$getAdvancement(), (ResourceKey)this.impl$advancementKey, scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant(cause, this.bridge$getAdvancement(), (ResourceKey)this.impl$advancementKey, criterion, player, Instant.now());
        }
        if (SpongeCommon.post(event)) {
            return false;
        }
        criterionProgress.grant();
        return true;
    }

    @Inject(method={"revokeProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$removeScoreCriteriaAndCallEvents(String rawCriterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$revokeCriterion(rawCriterion));
    }

    private boolean impl$revokeCriterion(String rawCriterion) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.criteria.get(rawCriterion);
        if (criterionProgress == null || !criterionProgress.isDone()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.revoke();
            return true;
        }
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.criterion();
        CriterionBridge criterionBridge = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        Advancement advancement = ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).advancement();
        ResourceKey key = (ResourceKey)this.impl$advancementKey;
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.name());
            int lastScore = scoreProgress.score();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, advancement, key, scoreCriterion, player, lastScore, score) : (score == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, advancement, key, scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, advancement, key, scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke(cause, advancement, key, criterion, player);
        }
        if (SpongeCommon.post(event)) {
            return false;
        }
        criterionProgress.revoke();
        return true;
    }

    private Optional<Advancement> impl$getOptionalAdvancement() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        AdvancementHolder advancement = SpongeCommon.server().getAdvancements().get(this.impl$advancementKey);
        return Optional.ofNullable(advancement).map(AdvancementHolder::value).map(Advancement.class::cast);
    }
}

