/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BedBlock.class})
public class BedBlockMixin {
    @Inject(method={"useWithoutItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onUseBed(BlockState param0, Level param1, BlockPos param2, Player param3, BlockHitResult param5, CallbackInfoReturnable<InteractionResult> cir) {
        if (!param1.isClientSide) {
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            BlockPos bedLocation = param5.getBlockPos();
            BlockSnapshot snapshot = ((ServerWorld)param1).createSnapshot(bedLocation.getX(), bedLocation.getY(), bedLocation.getZ());
            if (Sponge.eventManager().post(SpongeEventFactory.createSleepingEventPre(currentCause, snapshot, (Living)param3))) {
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
        }
    }

    @Inject(method={"useWithoutItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z")}, cancellable=true)
    private void impl$onExplodeBed(BlockState param0, Level param1, BlockPos param2, Player param3, BlockHitResult param5, CallbackInfoReturnable<InteractionResult> cir) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        BlockPos bedLocation = param5.getBlockPos();
        BlockSnapshot snapshot = ((ServerWorld)param1).createSnapshot(bedLocation.getX(), bedLocation.getY(), bedLocation.getZ());
        if (Sponge.eventManager().post(SpongeEventFactory.createSleepingEventFailed(currentCause, snapshot, (Living)param3))) {
            param3.startSleepInBed(param2).ifLeft(param1x -> {
                if (param1x != null) {
                    param3.displayClientMessage(param1x.getMessage(), true);
                }
            });
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

