/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.SpongeClientEngineConnection;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.SpongePacketHolder;
import org.spongepowered.common.network.SpongeServerEngineConnection;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.util.Constants;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin
extends SimpleChannelInboundHandler<Packet<?>>
implements ConnectionBridge {
    @Shadow
    private PacketListener packetListener;
    @Shadow
    private Channel channel;
    @Shadow
    private boolean disconnectionHandled;
    @Shadow
    @Final
    private Queue<Consumer<Connection>> pendingActions;
    private TransactionStore impl$transactionStore;
    private final Set<ResourceKey> impl$registeredChannels = Sets.newConcurrentHashSet();
    private @Nullable InetSocketAddress impl$virtualHost;
    private @Nullable MinecraftVersion impl$version;
    private @Nullable Component impl$kickReason;
    private ClientType impl$clientType = ClientType.VANILLA;
    private volatile boolean impl$disconnected;
    private SpongeEngineConnection impl$engineConnection;

    @Shadow
    public abstract SocketAddress getRemoteAddress();

    @Override
    public TransactionStore bridge$getTransactionStore() {
        return this.impl$transactionStore;
    }

    @Override
    public Set<ResourceKey> bridge$getRegisteredChannels() {
        return this.impl$registeredChannels;
    }

    @Override
    public ClientType bridge$getClientType() {
        return this.impl$clientType;
    }

    @Override
    public void bridge$setClientType(ClientType clientType) {
        this.impl$clientType = clientType;
    }

    @Override
    public InetSocketAddress bridge$getAddress() {
        SocketAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress bridge$getVirtualHost() {
        if (this.impl$virtualHost != null) {
            return this.impl$virtualHost;
        }
        SocketAddress local = this.channel.localAddress();
        if (local instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void bridge$setVirtualHost(String host, int port) {
        try {
            this.impl$virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.channel.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.impl$virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    public @Nullable Component bridge$getKickReason() {
        return this.impl$kickReason;
    }

    @Override
    public void bridge$setKickReason(Component component) {
        this.impl$kickReason = component;
    }

    @Override
    public MinecraftVersion bridge$getVersion() {
        return this.impl$version;
    }

    @Override
    public void bridge$setVersion(int version) {
        this.impl$version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSend(Packet<?> $$0, @Nullable PacketSendListener $$1, CallbackInfo ci) {
        if (this.disconnectionHandled) {
            if ($$1 instanceof PacketSender.SpongePacketSendListener) {
                PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$1;
                spongeListener.accept(new IOException("Connection has been closed."));
            }
            ci.cancel();
        }
    }

    @Redirect(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z"))
    private boolean impl$onQueue(Queue instance, final Object consumer, Packet<?> $$0, @Nullable PacketSendListener $$1, boolean $$2) {
        if ($$1 instanceof PacketSender.SpongePacketSendListener) {
            final PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$1;
            return instance.add(new SpongePacketHolder(){

                @Override
                public void apply(Throwable t) {
                    spongeListener.accept(t);
                }

                @Override
                public void accept(Connection connection) {
                    ((Consumer)consumer).accept(connection);
                }
            });
        }
        return instance.add(consumer);
    }

    @Inject(method={"handleDisconnection"}, at={@At(value="RETURN")})
    private void impl$onDisconnected(CallbackInfo ci) {
        Consumer<Connection> consumer;
        this.impl$engineConnection.disconnected();
        while ((consumer = this.pendingActions.poll()) != null) {
            if (!(consumer instanceof SpongePacketHolder)) continue;
            SpongePacketHolder packetHolder = (SpongePacketHolder)consumer;
            packetHolder.apply(new IOException("Connection has been closed."));
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;awaitUninterruptibly()Lio/netty/channel/ChannelFuture;")}, cancellable=true)
    private void impl$disconnectAsync(CallbackInfo ci) {
        ci.cancel();
        this.impl$disconnected = true;
    }

    @Inject(method={"isConnected"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onIsConnected(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$disconnected) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"exceptionCaught"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;disconnect(Lnet/minecraft/network/chat/Component;)V")})
    private void impl$onExceptionDisconnect(ChannelHandlerContext $$0, Throwable $$1, CallbackInfo ci) {
        SpongeCommon.logger().error("Disconnected due to error", $$1);
    }

    @Override
    public SpongeEngineConnection bridge$getEngineConnection() {
        return this.impl$engineConnection;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$onInit(PacketFlow packetFlow, CallbackInfo ci) {
        if (packetFlow == PacketFlow.CLIENTBOUND) {
            this.impl$engineConnection = new SpongeClientEngineConnection((Connection)this);
        } else if (packetFlow == PacketFlow.SERVERBOUND) {
            this.impl$engineConnection = new SpongeServerEngineConnection((Connection)this);
        }
        this.impl$transactionStore = new TransactionStore(this.impl$engineConnection);
    }
}

