/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.syncher;

import java.util.Optional;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.network.syncher.EntityDataAccessorBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={SynchedEntityData.class})
public abstract class SynchedEntityDataMixin {
    @Shadow
    @Final
    private SyncedDataHolder entity;
    @Shadow
    private boolean isDirty;

    @Shadow
    protected abstract <T> SynchedEntityData.DataItem<T> getItem(EntityDataAccessor<T> var1);

    @Overwrite
    public <T> void set(EntityDataAccessor<T> key, T value) {
        SynchedEntityData.DataItem<T> dataentry = this.getItem(key);
        Object currentValue = dataentry.getValue();
        T incomingValue = value;
        if (ObjectUtils.notEqual(value, (Object)currentValue)) {
            Optional<DataTransactionResult> optional;
            Optional converter;
            if (this.entity != null && ((Entity)this.entity).level() != null && !((Entity)this.entity).level().isClientSide && !((EntityBridge)this.entity).bridge$isConstructing() && (converter = ((EntityDataAccessorBridge)key).bridge$getDataConverter()).isPresent() && (optional = converter.get().createTransaction((Entity)this.entity, currentValue, value)).isPresent()) {
                DataTransactionResult transaction = optional.get();
                ChangeDataHolderEvent.ValueChange event = SpongeEventFactory.createChangeDataHolderEventValueChange(PhaseTracker.getCauseStackManager().currentCause(), transaction, (DataHolder.Mutable)this.entity);
                Sponge.eventManager().post(event);
                if (event.isCancelled()) {
                    return;
                }
                try {
                    value = converter.get().getValueFromEvent(currentValue, event.endResult());
                }
                catch (Exception e) {
                    value = incomingValue;
                }
            }
            dataentry.setValue(value);
            this.entity.onSyncedDataUpdated(key);
            dataentry.setDirty(true);
            this.isDirty = true;
        }
    }
}

