/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.world.scores.PlayerTeamAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;
import org.spongepowered.common.scoreboard.SpongeScore;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin
extends Scoreboard
implements ServerScoreboardBridge {
    @Shadow
    @Final
    private Set<Objective> trackedObjectives;
    private final List<ServerPlayer> impl$players = new ArrayList<ServerPlayer>();
    private boolean impl$apiCall;

    @Override
    public void bridge$addAPIObjective(org.spongepowered.api.scoreboard.objective.Objective objective) {
        if (objective instanceof SpongeObjective) {
            SpongeObjective so = (SpongeObjective)objective;
            this.impl$apiCall = true;
            Objective mcObjective = this.addObjective(objective.name(), (ObjectiveCriteria)objective.criterion(), SpongeAdventure.asVanilla(objective.displayName()), (ObjectiveCriteria.RenderType)objective.displayMode(), so.displayAutoUpdate(), so.numberFormat());
            this.impl$apiCall = false;
            ((ObjectiveBridge)mcObjective).bridge$setSpongeObjective(so);
            so.register(this);
            for (Score score : objective.scores().values()) {
                SpongeScore spongeScore = (SpongeScore)score;
                ScoreAccess accessor = this.getOrCreatePlayerScore(spongeScore.holder, mcObjective);
                spongeScore.registerAndUpdate(mcObjective, accessor);
            }
        }
    }

    @Override
    public void bridge$addMCObjective(Objective mcObjective) {
        if (!this.impl$apiCall) {
            SpongeObjective objective = SpongeObjective.fromVanilla(mcObjective);
            objective.register(this);
        }
    }

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjective(String name) {
        Objective objective = this.getObjective(name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjective(DisplaySlot slot) {
        Objective objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().get(slot);
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> bridge$getObjectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey((Object)criterion)) {
            return ((List)((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get((Object)criterion)).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<org.spongepowered.api.scoreboard.objective.Objective>();
    }

    @Override
    public void bridge$removeAPIObjective(org.spongepowered.api.scoreboard.objective.Objective objective) {
        if (objective instanceof SpongeObjective) {
            SpongeObjective so = (SpongeObjective)objective;
            this.impl$apiCall = true;
            Objective mcObjective = this.getObjective(objective.name());
            this.removeObjective(mcObjective);
            this.impl$apiCall = false;
            so.unregister(this);
        }
        for (Score score : objective.scores().values()) {
            objective.removeScore(score);
        }
    }

    @Override
    public void bridge$removeMCObjective(Objective mcObjective) {
        if (!this.impl$apiCall) {
            this.bridge$removeAPIObjective(((ObjectiveBridge)mcObjective).bridge$getSpongeObjective());
        }
    }

    @Override
    public void bridge$removeMCScore(ScoreHolder holder, Objective mcObjective) {
        if (!this.impl$apiCall) {
            SpongeObjective objective = ((ObjectiveBridge)mcObjective).bridge$getSpongeObjective();
            objective.removeScore(holder.getScoreboardName());
        }
    }

    @Override
    public void bridge$registerTeam(Team spongeTeam) {
        PlayerTeam team = (PlayerTeam)spongeTeam;
        if (this.getPlayerTeam(spongeTeam.name()) != null) {
            throw new IllegalArgumentException(String.format("A team with the name '%s' already exists!", spongeTeam.name()));
        }
        if (((PlayerTeamAccessor)team).accessor$scoreboard() != null) {
            throw new IllegalArgumentException("The passed in team is already registered to a scoreboard!");
        }
        ((PlayerTeamAccessor)team).accessor$scoreboard(this);
        ((ScoreboardAccessor)((Object)this)).accessor$teamsByName().put((Object)team.getName(), (Object)team);
        for (String entry : team.getPlayers()) {
            this.addPlayerToTeam(entry, team);
        }
        this.onTeamAdded(team);
    }

    @Override
    public void bridge$sendToPlayers(Packet<?> packet) {
        for (ServerPlayer player : this.impl$players) {
            player.connection.send(packet);
        }
    }

    @Override
    public void bridge$addPlayer(ServerPlayer player, boolean sendPackets) {
        this.impl$players.add(player);
        if (sendPackets) {
            for (PlayerTeam team : this.getPlayerTeams()) {
                player.connection.send((Packet)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)team, (boolean)true));
            }
            for (Objective objective : this.trackedObjectives) {
                player.connection.send((Packet)new ClientboundSetObjectivePacket(objective, 0));
                ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().forEach((displaySlot, objective1) -> {
                    if (objective1 == objective) {
                        player.connection.send((Packet)new ClientboundSetDisplayObjectivePacket(displaySlot, objective));
                    }
                });
                for (PlayerScoreEntry score : this.listPlayerScores(objective)) {
                    ClientboundSetScorePacket packetIn = new ClientboundSetScorePacket(score.owner(), objective.getName(), score.value(), Optional.ofNullable(score.display()), Optional.ofNullable(score.numberFormatOverride()));
                    player.connection.send((Packet)packetIn);
                }
            }
        }
    }

    @Override
    public void bridge$removePlayer(ServerPlayer player, boolean sendPackets) {
        this.impl$players.remove(player);
        if (sendPackets) {
            this.impl$removeScoreboard(player);
        }
    }

    public void removePlayerTeam(PlayerTeam team) {
        super.removePlayerTeam(team);
        ((PlayerTeamAccessor)team).accessor$scoreboard(null);
    }

    @Redirect(method={"onScoreChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onUpdateScoreValue(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onPlayerRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onPlayerScoreRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnRemovalOfObjective(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"setDisplayObjective"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnSetDisplayObjective(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"addPlayerToTeam"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnPlayerAdd(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"removePlayerFromTeam(Ljava/lang/String;Lnet/minecraft/world/scores/PlayerTeam;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnPlayerRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onObjectiveChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updatePlayersOnObjectiveDisplay(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamCreation(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamInfo(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"onTeamRemoved"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$updateAllPlayersOnTeamRemoval(PlayerList manager, Packet<?> packet) {
        this.bridge$sendToPlayers(packet);
    }

    @Redirect(method={"startTrackingObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayers(List list) {
        return this.impl$players.iterator();
    }

    @Redirect(method={"stopTrackingObjective"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0, remap=false))
    private Iterator impl$useOurScoreboardForPlayersOnRemoval(List list) {
        return this.impl$players.iterator();
    }

    private void impl$removeScoreboard(ServerPlayer player) {
        this.impl$removeTeams(player);
        this.impl$removeObjectives(player);
    }

    private void impl$removeTeams(ServerPlayer player) {
        for (PlayerTeam team : this.getPlayerTeams()) {
            player.connection.send((Packet)ClientboundSetPlayerTeamPacket.createRemovePacket((PlayerTeam)team));
        }
    }

    private void impl$removeObjectives(ServerPlayer player) {
        for (Objective objective : this.getObjectives()) {
            player.connection.send((Packet)new ClientboundSetObjectivePacket(objective, 1));
        }
    }

    @Override
    public void bridge$removeAPIScore(org.spongepowered.api.scoreboard.objective.Objective spongeObjective, Score spongeScore) {
        this.impl$apiCall = true;
        ScoreHolder holder = ((SpongeScore)spongeScore).holder;
        Objective mcObjective = this.getObjective(spongeObjective.name());
        this.resetSinglePlayerScore(holder, mcObjective);
        ((SpongeScore)spongeScore).unregister(mcObjective);
        this.impl$apiCall = false;
    }
}

