/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.api.entity.living.animal.horse.HorseLike;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.DismountTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.ai.goal.GoalMixin;

@Mixin(value={RunAroundLikeCrazyGoal.class})
public abstract class RunAroundLikeCrazyGoalMixin
extends GoalMixin {
    @Shadow
    @Final
    @Mutable
    private AbstractHorse horse;

    @Overwrite
    public void tick() {
        if (!this.horse.isTamed() && this.horse.getRandom().nextInt(50) == 0) {
            Entity entity = (Entity)this.horse.getPassengers().get(0);
            if (entity == null) {
                return;
            }
            if (entity instanceof Player) {
                int i = this.horse.getTemper();
                int j = this.horse.getMaxTemper();
                if (j > 0 && this.horse.getRandom().nextInt(j) < i) {
                    try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                        frame.pushCause(entity);
                        if (SpongeCommon.post(SpongeEventFactory.createTameEntityEvent(frame.currentCause(), (HorseLike)this.horse))) {
                            return;
                        }
                    }
                    this.horse.tameWithName((Player)entity);
                    return;
                }
                this.horse.modifyTemper(5);
            }
            if (((EntityBridge)this.horse).bridge$removePassengers(DismountTypes.DERAIL.get())) {
                this.horse.makeMad();
                this.horse.level().broadcastEntityEvent((Entity)this.horse, (byte)6);
            }
        }
    }
}

