/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.world.item.component.CustomDataAccessor;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataHolderProcessor;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements SpongeDataHolderBridge,
DataCompoundHolder {
    @Shadow
    @Final
    private PatchedDataComponentMap components;

    @Shadow
    public abstract boolean shadow$isEmpty();

    @Override
    public <E> Optional<E> bridge$get(Key<@NonNull ? extends Value<E>> key) {
        if (this.shadow$isEmpty()) {
            return Optional.empty();
        }
        return DataHolderProcessor.bridge$get(this, key);
    }

    @Override
    public <E> DataTransactionResult bridge$offer(Key<@NonNull ? extends Value<E>> key, E value) {
        if (this.shadow$isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return DataHolderProcessor.bridge$offer(this, key, value);
    }

    @Override
    public <E> DataTransactionResult bridge$remove(Key<@NonNull ? extends Value<E>> key) {
        if (this.shadow$isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return DataHolderProcessor.bridge$remove(this, key);
    }

    @Override
    public CompoundTag data$getCompound() {
        @Nullable CustomData customData = (CustomData)this.components.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData != CustomData.EMPTY) {
            return customData.getUnsafe();
        }
        return null;
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.components.set(DataComponents.CUSTOM_DATA, (Object)(nbt == null ? CustomData.EMPTY : CustomDataAccessor.invoker$new(nbt)));
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void impl$onCopy(CallbackInfoReturnable<ItemStack> info) {
        ((SpongeDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"split"}, at={@At(value="RETURN")})
    private void impl$onSplit(int amount, CallbackInfoReturnable<ItemStack> info) {
        ((SpongeDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="RETURN")})
    private void impl$onRead(ItemLike $$0, int $$1, PatchedDataComponentMap $$2, CallbackInfo ci) {
        if (!this.shadow$isEmpty()) {
            DataUtil.syncTagToData(this);
            DataUtil.syncDataToTag(this);
        }
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    private <T> void impl$onSetCustomData(DataComponentType<? super T> $$0, T $$1, CallbackInfoReturnable<T> cir) {
        if ($$0.equals((Object)DataComponents.CUSTOM_DATA)) {
            this.bridge$clear();
            DataUtil.syncTagToData(this);
            DataUtil.syncDataToTag(this);
        }
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ITEMSTACK;
    }
}

