/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.CustomNameableBridge;
import org.spongepowered.common.bridge.world.level.block.entity.BannerBlockEntityBridge;
import org.spongepowered.common.mixin.core.world.level.block.entity.BlockEntityMixin;

@Mixin(value={BannerBlockEntity.class})
public abstract class BannerBlockEntityMixin
extends BlockEntityMixin
implements BannerBlockEntityBridge,
CustomNameableBridge {
    @Shadow
    private net.minecraft.world.item.DyeColor baseColor;
    @Shadow
    @Nullable
    private Component name;

    private void impl$markDirtyAndUpdate() {
        this.shadow$setChanged();
        if (this.level != null && !this.level.isClientSide) {
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.shadow$getBlockPos());
        }
    }

    @Override
    public DyeColor bridge$getBaseColor() {
        return (DyeColor)this.baseColor;
    }

    @Override
    public void bridge$setBaseColor(DyeColor baseColor) {
        Objects.requireNonNull(baseColor, "Null DyeColor!");
        try {
            this.baseColor = (net.minecraft.world.item.DyeColor)baseColor;
        }
        catch (Exception e) {
            this.baseColor = net.minecraft.world.item.DyeColor.BLACK;
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public void bridge$setCustomDisplayName(Component customName) {
        this.name = customName;
    }
}

