/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements BlockEntityBridge,
DataCompoundHolder {
    @Shadow
    @Final
    private BlockEntityType<?> type;
    @Shadow
    private @Nullable BlockState blockState;
    @Shadow
    protected Level level;
    @Shadow
    @Final
    protected BlockPos worldPosition;
    private CompoundTag impl$customData;

    @Shadow
    public abstract BlockPos shadow$getBlockPos();

    @Shadow
    public abstract BlockState shadow$getBlockState();

    @Shadow
    public abstract void shadow$setChanged();

    @Override
    public CompoundTag data$getCompound() {
        return this.impl$customData;
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.impl$customData = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    @Inject(method={"saveMetadata"}, at={@At(value="RETURN")})
    private void impl$writeSpongeData(CompoundTag $$0, CallbackInfo ci) {
        if (DataUtil.syncDataToTag(this)) {
            $$0.merge(this.data$getCompound());
        }
    }

    @Inject(method={"loadWithComponents"}, at={@At(value="RETURN")})
    private void impl$readSpongeData(CompoundTag compound, HolderLookup.Provider $$1, CallbackInfo ci) {
        this.data$setCompound(compound);
        DataUtil.syncTagToData(this);
        this.data$setCompound(null);
    }

    public String toString() {
        ResourceKey key = (ResourceKey)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.type);
        return new StringJoiner(", ", BlockEntityMixin.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(key)).add("world=" + String.valueOf(this.level)).add("pos=" + String.valueOf(this.worldPosition)).add("blockstate=" + String.valueOf(this.blockState)).toString();
    }

    protected StringJoiner getPrettyPrinterStringHelper() {
        ResourceKey key = (ResourceKey)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.type);
        return new StringJoiner(", ", BlockEntityMixin.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(key)).add("world=" + String.valueOf(((ServerWorld)this.level).key())).add("pos=" + String.valueOf(this.worldPosition));
    }

    @Override
    public String bridge$getPrettyPrinterString() {
        return this.getPrettyPrinterStringHelper().toString();
    }
}

