/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.entity.carrier.Campfire;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.MixinTargetHelper;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.block.entity.CampfireBlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={CampfireBlockEntity.class})
public abstract class CampfireBlockEntityMixin
implements CampfireBlockEntityBridge {
    @Shadow
    @Final
    private NonNullList<ItemStack> items;
    @Shadow
    @Final
    private int[] cookingProgress;
    @Shadow
    @Final
    private int[] cookingTime;
    private final RecipeHolder[] impl$cookingRecipe = new RecipeHolder[4];
    private int impl$currentIndex;
    private SlotTransaction impl$pendingSlotTransaction;

    @Inject(method={"cookTick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;cookingProgress:[I", ordinal=1)})
    private static void impl$canCook(Level level, BlockPos pos, BlockState state, CampfireBlockEntity self, CallbackInfo ci, boolean hasChanged, int i, ItemStack itemStack) {
        ((CampfireBlockEntityMixin)self).impl$currentIndex = i;
        boolean isEmpty = itemStack.isEmpty();
        if (!isEmpty) {
            Cause cause = PhaseTracker.getCauseStackManager().currentCause();
            CampfireBlockEntityMixin mixinSelf = (CampfireBlockEntityMixin)MixinTargetHelper.cast(self);
            ItemStackSnapshot stack = ItemStackUtil.snapshotOf((ItemStack)mixinSelf.items.get(i));
            RecipeHolder recipe = mixinSelf.impl$cookingRecipe[i];
            CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (Campfire)self, stack, Optional.empty(), Optional.ofNullable(recipe).map(r -> (CookingRecipe)r.value()), Optional.ofNullable(recipe).map(r -> (ResourceKey)r.id()));
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                int n = i;
                ((CampfireBlockEntityMixin)self).cookingProgress[n] = ((CampfireBlockEntityMixin)self).cookingProgress[n] - 1;
            }
        }
    }

    @Inject(method={"cookTick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/world/Containers;dropItemStack(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V")})
    private static void impl$assembleCampfireResult(Level level, BlockPos pos, BlockState state, CampfireBlockEntity self, CallbackInfo ci, boolean hasChanged, int i, ItemStack itemStack, Container iInventory, ItemStack itemStack1) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        CampfireBlockEntityMixin mixinSelf = (CampfireBlockEntityMixin)MixinTargetHelper.cast(self);
        SlotTransaction transaction = new SlotTransaction(((Campfire)self).inventory().slot(i).get(), ItemStackUtil.snapshotOf(itemStack1), ItemStackSnapshot.empty());
        RecipeHolder recipe = mixinSelf.impl$cookingRecipe[i];
        CookingEvent.Finish event = SpongeEventFactory.createCookingEventFinish(cause, (Campfire)self, Optional.empty(), Optional.ofNullable(recipe).map(r -> (CookingRecipe)r.value()), Optional.ofNullable(recipe).map(r -> (ResourceKey)r.id()), Collections.singletonList(transaction));
        SpongeCommon.post(event);
        mixinSelf.impl$cookingRecipe[i] = null;
        mixinSelf.impl$pendingSlotTransaction = transaction;
    }

    @Inject(method={"cookTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;sendBlockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;I)V")})
    private static void impl$setCookingEventFinishResult(Level $$0, BlockPos $$1, BlockState $$2, CampfireBlockEntity $$3, CallbackInfo ci) {
        CampfireBlockEntityMixin mixinSelf = (CampfireBlockEntityMixin)MixinTargetHelper.cast($$3);
        mixinSelf.impl$pendingSlotTransaction.custom().ifPresent(item -> mixinSelf.items.set(((SlotAdapter)mixinSelf.impl$pendingSlotTransaction.slot()).getOrdinal(), (Object)ItemStackUtil.fromSnapshotToNative(item)));
        mixinSelf.impl$pendingSlotTransaction = null;
    }

    @Override
    public void bridge$placeRecipe(RecipeHolder<CampfireCookingRecipe> recipe) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.impl$cookingRecipe[i] = recipe;
            return;
        }
    }

    @Redirect(method={"cookTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isItemEnabled(Lnet/minecraft/world/flag/FeatureFlagSet;)Z"))
    private static boolean impl$checkInfiniteCookingTime(ItemStack instance, FeatureFlagSet featureFlagSet, Level level, BlockPos blockPos, BlockState state, CampfireBlockEntity self) {
        int cookingTime = ((CampfireBlockEntityMixin)self).cookingTime[((CampfireBlockEntityMixin)self).impl$currentIndex];
        if (cookingTime != -1) {
            return instance.isItemEnabled(featureFlagSet);
        }
        return false;
    }
}

