/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.level.LevelSettingsAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.fixer.LegacyUUIDCodec;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={PrimaryLevelData.class})
public abstract class PrimaryLevelDataMixin
implements WorldData,
PrimaryLevelDataBridge,
ResourceKeyBridge {
    @Shadow
    private LevelSettings settings;
    @Shadow
    private BlockPos spawnPos;
    @Shadow
    private float spawnAngle;
    private @Nullable ResourceKey impl$key;
    private DimensionType impl$dimensionType;
    private @Nullable SerializationBehavior impl$serializationBehavior;
    private @Nullable Component impl$displayName;
    private @Nullable Integer impl$viewDistance;
    private UUID impl$uniqueId = UUID.randomUUID();
    private Boolean impl$pvp;
    private InheritableConfigHandle<WorldConfig> impl$configAdapter;
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private boolean impl$customDifficulty = false;
    private boolean impl$customGameType = false;
    private boolean impl$customSpawnPosition = false;
    private boolean impl$loadOnStartup;
    private boolean impl$performsSpawnLogic;
    private BiMap<Integer, UUID> impl$mapUUIDIndex = HashBiMap.create();

    @Shadow
    public abstract boolean shadow$isDifficultyLocked();

    @Shadow
    public abstract void shadow$setSpawn(BlockPos var1, float var2);

    @Override
    public boolean bridge$isVanilla() {
        return ((PrimaryLevelData)this).getClass() == PrimaryLevelData.class;
    }

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public boolean bridge$valid() {
        return this.impl$key != null;
    }

    @Override
    public @Nullable ServerLevel bridge$world() {
        if (!Sponge.isServerAvailable()) {
            throw new IllegalStateException("The server is not available yet!");
        }
        ServerLevel world = SpongeCommon.server().getLevel(SpongeWorldManager.createRegistryKey(this.impl$key));
        if (world == null) {
            throw new IllegalStateException("The world is not available yet!");
        }
        ServerLevelData levelData = (ServerLevelData)world.getLevelData();
        if (levelData != this) {
            throw new IllegalStateException(String.format("The reference for the data for key '%s' does not match this object. This object is stale.", this.impl$key));
        }
        return world;
    }

    @Override
    public DimensionType bridge$dimensionType() {
        return this.impl$dimensionType;
    }

    @Override
    public void bridge$dimensionType(DimensionType type, boolean updatePlayers) {
        this.impl$dimensionType = type;
    }

    @Override
    public UUID bridge$uniqueId() {
        return this.impl$uniqueId;
    }

    @Override
    public boolean bridge$customDifficulty() {
        return this.impl$customDifficulty;
    }

    @Override
    public boolean bridge$customGameType() {
        return this.impl$customGameType;
    }

    @Override
    public boolean bridge$customSpawnPosition() {
        return this.impl$customSpawnPosition;
    }

    @Override
    public void bridge$forceSetDifficulty(Difficulty difficulty) {
        this.impl$customDifficulty = true;
        ((LevelSettingsAccessor)this.settings).accessor$difficulty(difficulty);
        this.impl$updateWorldForDifficultyChange(this.bridge$world(), this.shadow$isDifficultyLocked());
    }

    @Override
    public Optional<Boolean> bridge$pvp() {
        return Optional.ofNullable(this.impl$pvp);
    }

    @Override
    public void bridge$setPvp(@Nullable Boolean pvp) {
        this.impl$pvp = pvp;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public void bridge$setPerformsSpawnLogic(boolean performsSpawnLogic) {
        this.impl$performsSpawnLogic = performsSpawnLogic;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean loadOnStartup) {
        this.impl$loadOnStartup = loadOnStartup;
    }

    @Override
    public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.ofNullable(this.impl$serializationBehavior);
    }

    @Override
    public void bridge$setSerializationBehavior(@Nullable SerializationBehavior behavior) {
        this.impl$serializationBehavior = behavior;
    }

    @Override
    public Optional<Component> bridge$displayName() {
        return Optional.ofNullable(this.impl$displayName);
    }

    @Override
    public void bridge$setDisplayName(@Nullable Component displayName) {
        this.impl$displayName = displayName;
    }

    @Override
    public Optional<Integer> bridge$viewDistance() {
        return Optional.ofNullable(this.impl$viewDistance);
    }

    @Override
    public void bridge$setViewDistance(@Nullable Integer viewDistance) {
        this.impl$viewDistance = viewDistance;
        this.bridge$triggerViewDistanceLogic();
    }

    @Override
    public void bridge$triggerViewDistanceLogic() {
        ServerLevel world = this.bridge$world();
        if (world != null) {
            int actual = this.impl$viewDistance == null ? world.getServer().getPlayerList().getViewDistance() : this.impl$viewDistance.intValue();
            world.getChunkSource().setViewDistance(actual);
            ClientboundSetChunkCacheRadiusPacket packet = new ClientboundSetChunkCacheRadiusPacket(actual);
            world.players().forEach(p -> p.connection.send((Packet)packet));
        }
    }

    @Override
    public InheritableConfigHandle<WorldConfig> bridge$configAdapter() {
        return this.impl$configAdapter;
    }

    @Override
    public void bridge$configAdapter(InheritableConfigHandle<WorldConfig> adapter) {
        this.impl$configAdapter = adapter;
    }

    @Override
    public void bridge$populateFromLevelStem(LevelStem dimension) {
        LevelStemBridge bridge = (LevelStemBridge)dimension;
        this.impl$dimensionType = (DimensionType)dimension.type().value();
        this.impl$displayName = bridge.bridge$displayName();
        Difficulty difficulty = bridge.bridge$difficulty();
        GameType gameType = bridge.bridge$gameMode();
        Boolean isHardcore = bridge.bridge$hardcore();
        Boolean allowCommands = bridge.bridge$allowCommands();
        if (difficulty != null) {
            this.impl$customDifficulty = true;
        }
        if (gameType != null) {
            this.impl$customGameType = true;
        }
        this.settings = new LevelSettings(this.settings.levelName(), gameType == null ? this.settings.gameType() : gameType, isHardcore == null ? this.settings.hardcore() : isHardcore.booleanValue(), difficulty == null ? this.settings.difficulty() : difficulty, allowCommands == null ? this.settings.allowCommands() : allowCommands.booleanValue(), this.settings.gameRules(), this.settings.getDataConfiguration());
        Vector3i spawnPos = bridge.bridge$spawnPosition();
        if (spawnPos != null) {
            this.shadow$setSpawn(VecHelper.toBlockPos(spawnPos), this.spawnAngle);
            this.impl$customSpawnPosition = true;
        }
        this.impl$serializationBehavior = bridge.bridge$serializationBehavior();
        this.impl$pvp = bridge.bridge$pvp();
        this.impl$loadOnStartup = bridge.bridge$loadOnStartup();
        this.impl$performsSpawnLogic = bridge.bridge$performsSpawnLogic();
        this.impl$viewDistance = bridge.bridge$viewDistance();
    }

    @Override
    public BiMap<Integer, UUID> bridge$getMapUUIDIndex() {
        return this.impl$mapUUIDIndex;
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        int newIndex = this.impl$playerUniqueIdMap.size();
        this.impl$playerUniqueIdMap.put((Object)newIndex, (Object)uuid);
        return newIndex;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable((UUID)this.impl$playerUniqueIdMap.get((Object)index));
    }

    public ServerLevelData overworldData() {
        if (Level.OVERWORLD.location().equals((Object)this.impl$key)) {
            return (ServerLevelData)this;
        }
        return (ServerLevelData)SpongeCommon.server().getLevel(Level.OVERWORLD).getLevelData();
    }

    void impl$updateWorldForDifficultyChange(ServerLevel world, boolean isLocked) {
        MinecraftServer server = world.getServer();
        Difficulty difficulty = ((LevelData)this).getDifficulty();
        if (difficulty == Difficulty.HARD) {
            world.setSpawnSettings(true, true);
        } else if (server.isSingleplayer()) {
            world.setSpawnSettings(difficulty != Difficulty.PEACEFUL, true);
        } else {
            world.setSpawnSettings(((MinecraftServerAccessor)server).invoker$isSpawningMonsters(), server.isSpawningAnimals());
        }
        world.players().forEach(player -> player.connection.send((Packet)new ClientboundChangeDifficultyPacket(difficulty, isLocked)));
    }

    @Override
    public void bridge$hardcore(boolean hardcore) {
        ((LevelSettingsAccessor)this.settings).accessor$harcore(hardcore);
    }

    @Override
    public void bridge$allowCommands(boolean allowCommands) {
        ((LevelSettingsAccessor)this.settings).accessor$allowCommands(allowCommands);
    }

    @Override
    public void bridge$readSpongeLevelData(Dynamic<Tag> dynamic) {
        dynamic.get("UUID").read((Decoder)UUIDUtil.CODEC).result().ifPresent(value -> {
            this.impl$uniqueId = value;
        });
        dynamic.get("MapUUIDs").readMap((Decoder)Codec.STRING, (Decoder)UUIDUtil.CODEC).result().ifPresent(value -> {
            HashBiMap mapIndex = HashBiMap.create();
            for (Pair pair : value) {
                int id = Integer.parseInt((String)pair.getFirst());
                mapIndex.put((Object)id, (Object)((UUID)pair.getSecond()));
            }
            this.impl$mapUUIDIndex = mapIndex;
        });
        dynamic.get("PlayerIdTable").readList(LegacyUUIDCodec.CODEC).result().orElseGet(() -> dynamic.get("player-uuid-table").readList((Decoder)UUIDUtil.CODEC).result().orElse(Collections.emptyList())).forEach(uuid -> this.impl$playerUniqueIdMap.inverse().putIfAbsent(uuid, (Object)this.impl$playerUniqueIdMap.size()));
    }

    @Override
    public CompoundTag bridge$writeSpongeLevelData() {
        CompoundTag data = new CompoundTag();
        data.putUUID("UUID", this.impl$uniqueId);
        CompoundTag mapUUIDIndexTag = new CompoundTag();
        MapUtil.saveMapUUIDIndex(mapUUIDIndexTag, this.impl$mapUUIDIndex);
        data.put("MapUUIDs", (Tag)mapUUIDIndexTag);
        ListTag playerIdList = new ListTag();
        data.put("player-uuid-table", (Tag)playerIdList);
        this.impl$playerUniqueIdMap.values().forEach(uuid -> playerIdList.add((Object)new IntArrayTag(UUIDUtil.uuidToIntArray((UUID)uuid))));
        return data;
    }

    public String toString() {
        return new StringJoiner(", ", PrimaryLevelData.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.impl$key)).add("worldType=" + String.valueOf(this.impl$dimensionType)).add("uniqueId=" + String.valueOf(this.impl$uniqueId)).add("spawn=" + String.valueOf(VecHelper.toVector3i(this.spawnPos))).add("gameType=" + String.valueOf(((ServerLevelData)this).getGameType())).add("hardcore=" + ((LevelData)this).isHardcore()).add("difficulty=" + String.valueOf(((LevelData)this).getDifficulty())).toString();
    }
}

