/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.common.network.channel.ChannelBuffers;

public final class RegisterChannelUtil {
    private static final String SEPARATOR = "\u0000";

    public static List<ResourceKey> decodePayload(ChannelBuf payload) {
        byte[] content = payload.readBytes(payload.available());
        return Arrays.stream(new String(content, StandardCharsets.UTF_8).split(SEPARATOR)).map(ResourceKey::resolve).collect(Collectors.toList());
    }

    public static ChannelBuf encodePayload(Iterable<ResourceKey> keys) {
        String content = StreamSupport.stream(keys.spliterator(), false).map(Object::toString).collect(Collectors.joining(SEPARATOR));
        return ChannelBuffers.wrap(Unpooled.wrappedBuffer((byte[])content.getBytes(StandardCharsets.UTF_8)));
    }

    private RegisterChannelUtil() {
    }
}

