/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelIOException;
import org.spongepowered.api.network.channel.packet.PacketDispatcher;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.api.network.channel.packet.basic.BasicHandshakePacketDispatcher;
import org.spongepowered.api.network.channel.packet.basic.BasicPacketChannel;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.ChannelExceptionUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.AbstractPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongeFixedTransactionalPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeHandlerPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeRequestPacketResponse;
import org.spongepowered.common.network.channel.packet.SpongeTransactionalPacketBinding;
import org.spongepowered.common.util.Constants;

public final class SpongeBasicPacketChannel
extends AbstractPacketChannel
implements BasicPacketChannel {
    private final BasicHandshakePacketDispatcher handshake = new BasicHandshakePacketDispatcher(){

        @Override
        public <R extends org.spongepowered.api.network.channel.packet.Packet> CompletableFuture<R> sendTo(EngineConnection connection, RequestPacket<R> packet) {
            ConnectionUtil.checkHandshakePhase(connection);
            EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().getPacketListener();
            if (connection instanceof ClientSideConnection) {
                throw new UnsupportedOperationException("Request packets from the client to server are currently not supported for basic packet channels.");
            }
            CompletableFuture future = new CompletableFuture();
            this.sendRequestTo(connection, state, packet, future::complete, null, future);
            return future;
        }

        private <P extends RequestPacket<R>, R extends org.spongepowered.api.network.channel.packet.Packet> void sendRequestTo(EngineConnection connection, EngineConnectionState state, P request, @Nullable Consumer<R> success, @Nullable Runnable sendSuccess, CompletableFuture<?> future) {
            ChannelBuf payload;
            SpongeTransactionalPacketBinding binding = (SpongeTransactionalPacketBinding)SpongeBasicPacketChannel.this.requireBinding(request.getClass());
            try {
                payload = SpongeBasicPacketChannel.this.encodeLoginPayload(binding.opcode(), request);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, state, ex, future);
                return;
            }
            TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
            int transactionId = transactionStore.nextId();
            Packet<?> mcPacket = PacketUtil.createLoginPayloadRequest(new CustomQueryPayload(){

                public ResourceLocation id() {
                    return (ResourceLocation)Constants.Channels.FML_LOGIN_WRAPPER_CHANNEL;
                }

                public void write(FriendlyByteBuf var1) {
                    var1.writeBytes((ByteBuf)((FriendlyByteBuf)payload));
                }
            }, transactionId);
            PacketSender.sendTo(connection, mcPacket, throwable -> {
                if (throwable != null) {
                    SpongeBasicPacketChannel.this.handleException(connection, state, ChannelExceptionUtil.of(throwable), future);
                } else {
                    AbstractPacketChannel.TransactionData transactionData = new AbstractPacketChannel.TransactionData(request, binding, success, future);
                    transactionStore.put(transactionId, SpongeBasicPacketChannel.this, transactionData);
                    if (sendSuccess != null) {
                        sendSuccess.run();
                    }
                }
            });
        }

        private CompletableFuture<Void> sendNormalTo(EngineConnection connection, EngineConnectionState state, org.spongepowered.api.network.channel.packet.Packet packet) {
            ChannelBuf payload;
            SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = SpongeBasicPacketChannel.this.requireBinding(packet.getClass());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            try {
                payload = SpongeBasicPacketChannel.this.encodePayload(binding.opcode(), packet);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, state, ChannelExceptionUtil.of(ex), future);
                return future;
            }
            TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
            int transactionId = transactionStore.nextId();
            final ResourceKey key = SpongeBasicPacketChannel.this.key();
            Packet<?> mcPacket = PacketUtil.createLoginPayloadRequest(new CustomQueryPayload(){

                public ResourceLocation id() {
                    return (ResourceLocation)key;
                }

                public void write(FriendlyByteBuf var1) {
                    var1.writeBytes((ByteBuf)((FriendlyByteBuf)payload));
                }
            }, transactionId);
            PacketSender.sendTo(connection, mcPacket, future);
            return future;
        }

        @Override
        public CompletableFuture<Void> sendTo(EngineConnection connection, org.spongepowered.api.network.channel.packet.Packet packet) {
            ConnectionUtil.checkHandshakePhase(connection);
            EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().getPacketListener();
            if (connection instanceof ClientSideConnection) {
                throw new UnsupportedOperationException("Packets from the client to server are currently not supported for basic packet channels.");
            }
            if (packet instanceof RequestPacket) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.sendRequestTo(connection, state, (RequestPacket)packet, result -> {}, () -> future.complete(null), future);
                return future;
            }
            return this.sendNormalTo(connection, state, packet);
        }

        @Override
        public <R extends org.spongepowered.api.network.channel.packet.Packet> CompletableFuture<R> sendToServer(RequestPacket<R> packet) {
            throw new UnsupportedOperationException("Request packets from the client to server are currently not supported for basic packet channels.");
        }

        @Override
        public CompletableFuture<Void> sendToServer(org.spongepowered.api.network.channel.packet.Packet packet) {
            throw new UnsupportedOperationException("Packets from the client to server are currently not supported for basic packet channels.");
        }
    };
    private final PacketDispatcher play = new PacketDispatcher(){

        @Override
        public boolean isSupportedBy(EngineConnection connection) {
            return ConnectionUtil.getRegisteredChannels(connection).contains(SpongeBasicPacketChannel.this.key());
        }

        @Override
        public CompletableFuture<Void> sendTo(EngineConnection connection, org.spongepowered.api.network.channel.packet.Packet packet) {
            ChannelBuf payload;
            ConnectionUtil.checkPlayPhase(connection);
            EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().getPacketListener();
            SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = SpongeBasicPacketChannel.this.requireBinding(packet.getClass());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            if (!SpongeBasicPacketChannel.this.checkSupported(connection, state, future)) {
                return future;
            }
            try {
                payload = SpongeBasicPacketChannel.this.encodePayload(binding.opcode(), packet);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, state, ex, future);
                return future;
            }
            Packet<?> mcPacket = PacketUtil.createPlayPayload(SpongeBasicPacketChannel.this.payloadType(), payload, connection.side());
            PacketSender.sendTo(connection, mcPacket, future);
            return future;
        }
    };

    public SpongeBasicPacketChannel(int type, ResourceKey key, SpongeChannelManager registry) {
        super(type, key, registry);
    }

    @Override
    public BasicHandshakePacketDispatcher handshake() {
        return this.handshake;
    }

    @Override
    public PacketDispatcher play() {
        return this.play;
    }

    private ChannelBuf encodePayload(int opcode, org.spongepowered.api.network.channel.packet.Packet packet) {
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        payload.writeByte((byte)opcode);
        this.encodePayload(payload, packet);
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuf encodeLoginPayload(int opcode, org.spongepowered.api.network.channel.packet.Packet packet) {
        ChannelBuf loginPayload = this.manager().getBufferAllocator().buffer();
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        try {
            this.encodePayloadUnsafe(payload, packet);
            loginPayload.writeString(this.key().formatted());
            loginPayload.writeVarInt(payload.available() + 1);
            loginPayload.writeByte((byte)opcode);
            ChannelBuffers.write(loginPayload, payload);
        }
        finally {
            ChannelBuffers.release(payload);
        }
        return loginPayload;
    }

    private int readOpcode(ChannelBuf payload) {
        return payload.readByte() & 0xFF;
    }

    @Override
    protected void handlePlayPayload(EngineConnection connection, EngineConnectionState state, ChannelBuf payload) {
        int opcode = this.readOpcode(payload);
        SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = this.requireBinding(opcode);
        org.spongepowered.api.network.channel.packet.Packet packet = this.decodePayload(() -> (org.spongepowered.api.network.channel.packet.Packet)binding.getPacketConstructor().get(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            this.handle(connection, state, (SpongeHandlerPacketBinding)binding, packet);
        }
    }

    @Override
    protected void handleLoginRequestPayload(final EngineConnection connection, final EngineConnectionState state, final int transactionId, ChannelBuf payload) {
        int opcode = this.readOpcode(payload);
        SpongePacketBinding<org.spongepowered.api.network.channel.packet.Packet> binding = this.requireBinding(opcode);
        org.spongepowered.api.network.channel.packet.Packet packet = this.decodePayload(() -> (org.spongepowered.api.network.channel.packet.Packet)binding.getPacketConstructor().get(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            SpongeHandlerPacketBinding handlerBinding = (SpongeHandlerPacketBinding)binding;
            this.handle(connection, state, handlerBinding, packet);
            PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
        } else {
            final SpongeTransactionalPacketBinding transactionalBinding = (SpongeTransactionalPacketBinding)binding;
            RequestPacketHandler<org.spongepowered.api.network.channel.packet.Packet, org.spongepowered.api.network.channel.packet.Packet, EngineConnectionState> handler = transactionalBinding.getRequestHandler(state);
            boolean success = false;
            if (handler != null) {
                SpongeRequestPacketResponse<org.spongepowered.api.network.channel.packet.Packet> response = new SpongeRequestPacketResponse<org.spongepowered.api.network.channel.packet.Packet>(){

                    @Override
                    protected void fail0(ChannelException exception) {
                        Packet<?> mcPacket = PacketUtil.createLoginPayloadResponse(null, transactionId);
                        PacketSender.sendTo(connection, mcPacket);
                    }

                    @Override
                    protected void success0(org.spongepowered.api.network.channel.packet.Packet response) {
                        try {
                            ChannelBuf responsePayload = SpongeBasicPacketChannel.this.encodeLoginPayload(transactionalBinding.opcode(), response);
                            Packet<?> mcPacket = PacketUtil.createLoginPayloadResponse(var1 -> var1.writeBytes((ByteBuf)((FriendlyByteBuf)responsePayload)), transactionId);
                            PacketSender.sendTo(connection, mcPacket);
                        }
                        catch (Throwable ex) {
                            SpongeBasicPacketChannel.this.handleException(connection, state, new ChannelIOException("Failed to encode response packet", ex), null);
                        }
                    }
                };
                try {
                    handler.handleRequest(packet, state, response);
                    success = true;
                }
                catch (Throwable ex) {
                    this.handleException(connection, state, new ChannelIOException("Failed to handle request packet", ex), null);
                }
            }
            if (!success) {
                Packet<?> mcPacket = PacketUtil.createLoginPayloadResponse(null, transactionId);
                PacketSender.sendTo(connection, mcPacket);
            }
        }
    }

    @Override
    protected void handleTransactionResponse(EngineConnection connection, EngineConnectionState state, Object stored, TransactionResult result) {
        AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored;
        this.handleTransactionResponse(connection, state, transactionData, result);
    }

    private <P extends RequestPacket<R>, R extends org.spongepowered.api.network.channel.packet.Packet> void handleTransactionResponse(EngineConnection connection, EngineConnectionState state, AbstractPacketChannel.TransactionData<P, R> transactionData, TransactionResult result) {
        SpongeTransactionalPacketBinding binding = transactionData.binding;
        Object request = transactionData.request;
        if (result.isSuccess()) {
            ChannelBuf responsePayload = result.getPayload();
            responsePayload.readString();
            int actualLength = responsePayload.readVarInt();
            responsePayload = responsePayload.readSlice(actualLength);
            try {
                Supplier<Object> responseConstructor;
                int opcode = this.readOpcode(responsePayload);
                if (binding instanceof SpongeFixedTransactionalPacketBinding) {
                    responseConstructor = ((SpongeFixedTransactionalPacketBinding)binding).getResponsePacketConstructor();
                } else {
                    SpongeHandlerPacketBinding responseBinding = (SpongeHandlerPacketBinding)this.byOpcode.get(opcode);
                    if (responseBinding == null) {
                        throw new ChannelIOException("Unknown packet opcode: " + opcode);
                    }
                    responseConstructor = responseBinding.getPacketConstructor();
                }
                Object responsePacket = this.decodePayload(responseConstructor, responsePayload);
                if (transactionData.success != null) {
                    transactionData.success.accept(responsePacket);
                }
                this.handleResponse(connection, state, binding, request, responsePacket);
            }
            catch (Throwable ex) {
                this.handleException(connection, state, ex, transactionData.future);
            }
        } else {
            this.handleException(connection, state, result.getCause(), transactionData.future);
            this.handleResponseFailure(connection, state, binding, request, result.getCause());
        }
    }
}

