/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.raw;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;
import org.spongepowered.common.network.PacketUtil;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.channel.ConcurrentMultimap;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.raw.SpongeRawDataChannel;

public class SpongeRawPlayDataChannel
implements RawPlayDataChannel {
    private final ConcurrentMultimap<Class<?>, RawPlayDataHandler<?>> handlers = new ConcurrentMultimap();
    private final SpongeRawDataChannel parent;

    public SpongeRawPlayDataChannel(SpongeRawDataChannel parent) {
        this.parent = parent;
    }

    @Override
    public SpongeRawDataChannel parent() {
        return this.parent;
    }

    @Override
    public boolean isSupportedBy(EngineConnection connection) {
        Objects.requireNonNull(connection, "connection");
        return ConnectionUtil.getRegisteredChannels(connection).contains(this.parent.key());
    }

    @Override
    public void addHandler(RawPlayDataHandler<EngineConnectionState> handler) {
        this.addHandler(EngineConnectionState.class, handler);
    }

    @Override
    public <S extends EngineConnectionState> void addHandler(Class<S> connectionState, RawPlayDataHandler<? super S> handler) {
        Objects.requireNonNull(connectionState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.put((Object)connectionState, (Object)handler));
    }

    @Override
    public void removeHandler(RawPlayDataHandler<?> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> entry.getValue() == handler));
    }

    @Override
    public <S extends EngineConnectionState> void removeHandler(Class<S> connectionState, RawPlayDataHandler<? super S> handler) {
        Objects.requireNonNull(connectionState, "connectionType");
        Objects.requireNonNull(handler, "handler");
        this.handlers.modify(map -> map.entries().removeIf(entry -> ((Class)entry.getKey()).isAssignableFrom(connectionState) && entry.getValue() == handler));
    }

    @Override
    public CompletableFuture<Void> sendTo(EngineConnection connection, Consumer<ChannelBuf> consumer) {
        ChannelBuf payload;
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(consumer, "payload");
        ConnectionUtil.checkPlayPhase(connection);
        EngineConnectionState state = (EngineConnectionState)((SpongeEngineConnection)connection).connection().getPacketListener();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            payload = this.parent.encodePayload(consumer);
        }
        catch (Throwable ex) {
            this.parent.handleException(connection, state, ex, future);
            return future;
        }
        Packet<?> mcPacket = PacketUtil.createPlayPayload(this.parent.payloadType(), payload, connection.side());
        PacketSender.sendTo(connection, mcPacket, future);
        return future;
    }

    private <S extends EngineConnectionState> Collection<RawPlayDataHandler<? super S>> getHandlers(S state) {
        return SpongeChannel.getResponseHandlers(state, this.handlers.get());
    }

    <S extends EngineConnectionState> void handlePayload(S state, ChannelBuf payload) {
        for (RawPlayDataHandler<S> handler : this.getHandlers(state)) {
            handler.handlePayload(payload.slice(), state);
        }
    }
}

