/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProxiedRegistryAccess
implements RegistryAccess {
    private final RegistryAccess access;
    private final Map<ResourceKey<? extends Registry<?>>, Registry<?>> overrides;

    public ProxiedRegistryAccess(RegistryAccess access, Map<ResourceKey<? extends Registry<?>>, Registry<?>> overrides) {
        this.access = access;
        this.overrides = Map.copyOf(overrides);
    }

    public <E> Optional<Registry<E>> registry(ResourceKey<? extends Registry<? extends E>> var1) {
        @Nullable Registry<?> override = this.overrides.get(var1);
        if (override != null) {
            return Optional.of(override);
        }
        return this.access.registry(var1);
    }

    public Stream<RegistryAccess.RegistryEntry<?>> registries() {
        return Stream.concat(this.access.registries().filter(entry -> !this.overrides.containsKey(entry.key())), this.overrides.entrySet().stream().map(entry -> new RegistryAccess.RegistryEntry((ResourceKey)entry.getKey(), (Registry)entry.getValue())));
    }
}

