/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeScore;

public final class SpongeObjective
implements org.spongepowered.api.scoreboard.objective.Objective {
    private final String name;
    private final Criterion criterion;
    private final Map<String, Score> scores = new HashMap<String, Score>();
    private final Set<net.minecraft.world.scores.Scoreboard> scoreboards = new HashSet<net.minecraft.world.scores.Scoreboard>();
    private Component displayName;
    private ObjectiveDisplayMode displayMode;
    private boolean displayAutoUpdate;
    private NumberFormat numberFormat;

    public SpongeObjective(String name, Criterion criterion) {
        this.name = name;
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(name);
        this.displayMode = ObjectiveDisplayModes.INTEGER.get();
        this.criterion = criterion;
    }

    public static SpongeObjective fromVanilla(Objective mcObjective) {
        SpongeObjective objective = new SpongeObjective(mcObjective.getName(), (Criterion)mcObjective.getCriteria());
        objective.setDisplayMode((ObjectiveDisplayMode)mcObjective.getRenderType());
        objective.setDisplayName(SpongeAdventure.asAdventure(mcObjective.getDisplayName()));
        objective.setDisplayAutoUpdate(mcObjective.displayAutoUpdate());
        objective.setNumberFormat(mcObjective.numberFormat());
        ((ObjectiveBridge)mcObjective).bridge$setSpongeObjective(objective);
        return objective;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Component displayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(Component displayName) throws IllegalArgumentException {
        this.displayName = displayName;
        this.updateDisplayName();
    }

    public void storeDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    @Override
    public Criterion criterion() {
        return this.criterion;
    }

    @Override
    public ObjectiveDisplayMode displayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.updateDisplayMode();
    }

    public void storeDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public Map<String, Score> scores() {
        return new HashMap<String, Score>(this.scores);
    }

    @Override
    public boolean hasScore(String name) {
        return this.scores.containsKey(name);
    }

    @Override
    public void addScore(Score score) throws IllegalArgumentException {
        if (this.scores.containsKey(score.name())) {
            throw new IllegalArgumentException(String.format("A score with the name %s already exists!", score.name()));
        }
        this.scores.put(score.name(), score);
        SpongeScore spongeScore = (SpongeScore)score;
        for (net.minecraft.world.scores.Scoreboard scoreboard : this.scoreboards) {
            Objective mcObjective = scoreboard.getObjective(this.name);
            ScoreAccess accessor = scoreboard.getOrCreatePlayerScore(spongeScore.holder, mcObjective);
            spongeScore.registerAndUpdate(mcObjective, accessor);
        }
    }

    @Override
    public Optional<Score> findScore(String name) {
        return Optional.ofNullable(this.scores.get(name));
    }

    @Override
    public Score findOrCreateScore(String name) {
        if (this.scores.containsKey(name)) {
            return this.scores.get(name);
        }
        SpongeScore score = new SpongeScore(name);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean hasScore(Entity entity) {
        return this.scores.containsKey(((ScoreHolder)entity).getScoreboardName());
    }

    @Override
    public boolean hasScore(GameProfile profile) {
        return this.scores.containsKey(profile.name().get());
    }

    @Override
    public Score findOrCreateScore(Entity entity) {
        if (this.scores.containsKey(((ScoreHolder)entity).getScoreboardName())) {
            return this.scores.get(((ScoreHolder)entity).getScoreboardName());
        }
        SpongeScore score = new SpongeScore(entity);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean removeScore(Entity entity) {
        Optional<Score> score = this.findScore(((ScoreHolder)entity).getScoreboardName());
        return score.filter(this::removeScore).isPresent();
    }

    @Override
    public Score findOrCreateScore(GameProfile profile) {
        if (this.scores.containsKey(profile.name().get())) {
            return this.scores.get(profile.name().get());
        }
        SpongeScore score = new SpongeScore(profile);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean removeScore(GameProfile profile) {
        Optional<Score> score = this.findScore(profile.name().get());
        return score.filter(this::removeScore).isPresent();
    }

    @Override
    public boolean removeScore(Score spongeScore) {
        if (!this.scores.containsKey(spongeScore.name())) {
            return false;
        }
        for (net.minecraft.world.scores.Scoreboard scoreboard : this.scoreboards) {
            ((ServerScoreboardBridge)scoreboard).bridge$removeAPIScore(this, spongeScore);
        }
        this.scores.remove(spongeScore.name());
        return true;
    }

    @Override
    public boolean removeScore(String name) {
        Optional<Score> score = this.findScore(name);
        return score.filter(this::removeScore).isPresent();
    }

    @Override
    public Set<Scoreboard> scoreboards() {
        return new HashSet<net.minecraft.world.scores.Scoreboard>(this.scoreboards);
    }

    private void updateDisplayMode() {
        for (net.minecraft.world.scores.Scoreboard scoreboard : this.scoreboards) {
            Objective objective = scoreboard.getObjective(this.name);
            objective.setRenderType((ObjectiveCriteria.RenderType)this.displayMode);
        }
    }

    private void updateDisplayName() {
        for (net.minecraft.world.scores.Scoreboard scoreboard : this.scoreboards) {
            Objective objective = scoreboard.getObjective(this.name);
            objective.setDisplayName(SpongeAdventure.asVanilla(this.displayName));
        }
    }

    public boolean displayAutoUpdate() {
        return this.displayAutoUpdate;
    }

    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void setDisplayAutoUpdate(boolean displayAutoUpdate) {
        this.displayAutoUpdate = displayAutoUpdate;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void register(net.minecraft.world.scores.Scoreboard scoreboard) {
        this.scoreboards.add(scoreboard);
    }

    public void unregister(net.minecraft.world.scores.Scoreboard scoreboard) {
        this.scoreboards.remove(scoreboard);
    }

    public static final class Builder
    implements Objective.Builder {
        private @Nullable String name;
        private @Nullable Component displayName;
        private @Nullable Criterion criterion;
        private @Nullable ObjectiveDisplayMode objectiveDisplayMode;

        @Override
        public Objective.Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public Objective.Builder displayName(Component displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        @Override
        public Objective.Builder criterion(Criterion criterion) {
            this.criterion = Objects.requireNonNull(criterion);
            return this;
        }

        @Override
        public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
            this.objectiveDisplayMode = Objects.requireNonNull(objectiveDisplayMode);
            return this;
        }

        @Override
        public Objective.Builder from(org.spongepowered.api.scoreboard.objective.Objective value) {
            Objects.requireNonNull(value);
            this.name = value.name();
            this.displayName = value.displayName();
            this.criterion = value.criterion();
            this.objectiveDisplayMode = value.displayMode();
            return this;
        }

        @Override
        public Builder reset() {
            this.name = null;
            this.displayName = null;
            this.criterion = null;
            this.objectiveDisplayMode = null;
            return this;
        }

        @Override
        public org.spongepowered.api.scoreboard.objective.Objective build() {
            if (this.name == null) {
                throw new IllegalStateException("Name cannot be null!");
            }
            if (this.criterion == null) {
                throw new IllegalStateException("Criterion cannot be null!");
            }
            SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
            if (this.displayName != null) {
                objective.setDisplayName(this.displayName);
            }
            if (this.objectiveDisplayMode != null) {
                objective.setDisplayMode(this.objectiveDisplayMode);
            } else if (this.criterion instanceof ObjectiveCriteria) {
                objective.setDisplayMode((ObjectiveDisplayMode)((ObjectiveCriteria)this.criterion).getDefaultRenderType());
            }
            return objective;
        }
    }
}

