/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class BookUtil {
    public static final int WINDOW_PLAYER_INVENTORY = 0;
    private static final Locale STARTER_LOCALE = new Locale("placeholder", "LANG");

    public static void fakeBookView(Book book, Collection<? extends Player> players) {
        ItemStack item = ItemStack.of(ItemTypes.WRITTEN_BOOK, 1);
        Locale lastLocale = STARTER_LOCALE;
        for (Player player : players) {
            if (!Objects.equals(player.locale(), lastLocale)) {
                lastLocale = player.locale();
                item.offer(Keys.CUSTOM_NAME, GlobalTranslator.render((Component)book.title(), (Locale)lastLocale));
                item.offer(Keys.AUTHOR, GlobalTranslator.render((Component)book.author(), (Locale)lastLocale));
                Locale finalLastLocale = lastLocale;
                item.offer(Keys.PAGES, Lists.transform((List)book.pages(), page -> GlobalTranslator.render((Component)page, (Locale)finalLastLocale)));
            }
            ServerPlayer mcPlayer = (ServerPlayer)player;
            ServerGamePacketListenerImpl receiver = mcPlayer.connection;
            Inventory inventory = mcPlayer.getInventory();
            int bookSlot = inventory.items.size() + inventory.selected;
            receiver.send((Packet)new ClientboundContainerSetSlotPacket(0, mcPlayer.containerMenu.getStateId(), bookSlot, ItemStackUtil.toNative(item)));
            receiver.send((Packet)new ClientboundOpenBookPacket(InteractionHand.MAIN_HAND));
            receiver.send((Packet)new ClientboundContainerSetSlotPacket(0, mcPlayer.containerMenu.getStateId(), bookSlot, inventory.getSelected()));
        }
    }

    private BookUtil() {
    }
}

