/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;

public final class PortionTypeUtil {
    public static PortionType getFor(BedPart part) {
        return switch (part) {
            default -> throw new MatchException(null, null);
            case BedPart.HEAD -> PortionTypes.TOP.get();
            case BedPart.FOOT -> PortionTypes.BOTTOM.get();
        };
    }

    public static PortionType getFor(DoubleBlockHalf part) {
        return switch (part) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> PortionTypes.TOP.get();
            case DoubleBlockHalf.LOWER -> PortionTypes.BOTTOM.get();
        };
    }

    public static PortionType getFor(Half half) {
        return (PortionType)half;
    }

    public static BedPart getBedPartFor(PortionType value) {
        return value == PortionTypes.TOP.get() ? BedPart.HEAD : (value == PortionTypes.BOTTOM.get() ? BedPart.FOOT : null);
    }

    public static DoubleBlockHalf getDoubleBlockHalfFor(PortionType value) {
        return value == PortionTypes.TOP.get() ? DoubleBlockHalf.UPPER : (value == PortionTypes.BOTTOM.get() ? DoubleBlockHalf.LOWER : null);
    }

    public static Half getHalfFor(PortionType value) {
        return value == PortionTypes.TOP.get() ? Half.TOP : (value == PortionTypes.BOTTOM.get() ? Half.BOTTOM : null);
    }

    public static @Nullable PortionType getFromBedBlock(BlockState holder, EnumProperty<BedPart> property) {
        return PortionTypeUtil.getFor((BedPart)holder.getValue(property));
    }

    public static @Nullable BlockState setForBedBlock(BlockState holder, PortionType value, EnumProperty<BedPart> property) {
        BedPart bedPart = PortionTypeUtil.getBedPartFor(value);
        if (bedPart == null) {
            return null;
        }
        return (BlockState)holder.setValue(property, (Comparable)bedPart);
    }

    public static PortionType getFromDoubleBlock(BlockState holder, EnumProperty<DoubleBlockHalf> property) {
        return PortionTypeUtil.getFor((DoubleBlockHalf)holder.getValue(property));
    }

    public static BlockState setForDoubleBlock(BlockState holder, PortionType value, EnumProperty<DoubleBlockHalf> property) {
        DoubleBlockHalf half = PortionTypeUtil.getDoubleBlockHalfFor(value);
        if (half == null) {
            return null;
        }
        return (BlockState)holder.setValue(property, (Comparable)half);
    }

    public static PortionType getFromHalfBlock(BlockState holder, EnumProperty<Half> property) {
        Half half = (Half)holder.getValue(property);
        return PortionTypeUtil.getFor(half);
    }

    public static BlockState setForHalfBlock(BlockState holder, PortionType value, EnumProperty<Half> property) {
        Half half = PortionTypeUtil.getHalfFor(value);
        return (BlockState)holder.setValue(property, (Comparable)half);
    }

    private PortionTypeUtil() {
    }
}

