/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeAABB
implements AABB {
    private final Vector3d min;
    private final Vector3d max;
    private @Nullable Vector3d size = null;
    private @Nullable Vector3d center = null;

    public SpongeAABB(Vector3d v1, Vector3d v2) {
        this.min = v1.min(v2);
        this.max = v1.max(v2);
        if (this.min.x() == this.max.x()) {
            throw new IllegalArgumentException("The box is generate on x!");
        }
        if (this.min.y() == this.max.y()) {
            throw new IllegalArgumentException("The box is generate on y!");
        }
        if (this.min.z() == this.max.z()) {
            throw new IllegalArgumentException("The box is generate on z!");
        }
    }

    @Override
    public Vector3d min() {
        return this.min;
    }

    @Override
    public Vector3d max() {
        return this.max;
    }

    @Override
    public Vector3d center() {
        if (this.center == null) {
            this.center = this.min.add(this.size().div(2.0f));
        }
        return this.center;
    }

    @Override
    public Vector3d size() {
        if (this.size == null) {
            this.size = this.max.sub(this.min);
        }
        return this.size;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        Vector3d min = this.min;
        Vector3d max = this.max;
        return min.x() <= x && max.x() >= x && min.y() <= y && max.y() >= y && min.z() <= z && max.z() >= z;
    }

    @Override
    public boolean intersects(AABB other) {
        Objects.requireNonNull(other, "other");
        Vector3d mins = this.min;
        Vector3d maxs = this.max;
        Vector3d mino = other.min();
        Vector3d maxo = other.max();
        return maxs.x() >= mino.x() && maxo.x() >= mins.x() && maxs.y() >= mino.y() && maxo.y() >= mins.y() && maxs.z() >= mino.z() && maxo.z() >= mins.z();
    }

    @Override
    public Optional<Tuple<Vector3d, Vector3d>> intersects(Vector3d start, Vector3d direction) {
        Vector3d normal;
        double t;
        Vector3d zNormal;
        double tzMax;
        double tzMin;
        Vector3d normalMax;
        double tMax;
        Vector3d normalMin;
        double tMin;
        Vector3d yNormal;
        double tyMax;
        double tyMin;
        Vector3d xNormal;
        double txMax;
        double txMin;
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(direction, "direction");
        if (Math.copySign(1.0, direction.x()) > 0.0) {
            txMin = (this.min.x() - start.x()) / direction.x();
            txMax = (this.max.x() - start.x()) / direction.x();
            xNormal = Vector3d.UNIT_X;
        } else {
            txMin = (this.max.x() - start.x()) / direction.x();
            txMax = (this.min.x() - start.x()) / direction.x();
            xNormal = Vector3d.UNIT_X.negate();
        }
        if (Math.copySign(1.0, direction.y()) > 0.0) {
            tyMin = (this.min.y() - start.y()) / direction.y();
            tyMax = (this.max.y() - start.y()) / direction.y();
            yNormal = Vector3d.UNIT_Y;
        } else {
            tyMin = (this.max.y() - start.y()) / direction.y();
            tyMax = (this.min.y() - start.y()) / direction.y();
            yNormal = Vector3d.UNIT_Y.negate();
        }
        if (txMin > tyMax || txMax < tyMin) {
            return Optional.empty();
        }
        if (tyMin == txMin) {
            tMin = tyMin;
            normalMin = xNormal.negate().sub(yNormal);
        } else if (tyMin > txMin) {
            tMin = tyMin;
            normalMin = yNormal.negate();
        } else {
            tMin = txMin;
            normalMin = xNormal.negate();
        }
        if (tyMax == txMax) {
            tMax = tyMax;
            normalMax = xNormal.add(yNormal);
        } else if (tyMax < txMax) {
            tMax = tyMax;
            normalMax = yNormal;
        } else {
            tMax = txMax;
            normalMax = xNormal;
        }
        if (Math.copySign(1.0, direction.z()) > 0.0) {
            tzMin = (this.min.z() - start.z()) / direction.z();
            tzMax = (this.max.z() - start.z()) / direction.z();
            zNormal = Vector3d.UNIT_Z;
        } else {
            tzMin = (this.max.z() - start.z()) / direction.z();
            tzMax = (this.min.z() - start.z()) / direction.z();
            zNormal = Vector3d.UNIT_Z.negate();
        }
        if (tMin > tzMax || tMax < tzMin) {
            return Optional.empty();
        }
        if (tzMin == tMin) {
            normalMin = normalMin.sub(zNormal);
        } else if (tzMin > tMin) {
            tMin = tzMin;
            normalMin = zNormal.negate();
        }
        if (tzMax == tMax) {
            normalMax = normalMax.add(zNormal);
        } else if (tzMax < tMax) {
            tMax = tzMax;
            normalMax = zNormal;
        }
        if (tMax < 0.0) {
            return Optional.empty();
        }
        if (tMin < 0.0) {
            t = tMax;
            normal = normalMax;
        } else {
            t = tMin;
            normal = normalMin;
        }
        normal = normal.normalize();
        double x = normal.x() > 0.0 ? this.max.x() : (normal.x() < 0.0 ? this.min.x() : direction.x() * t + start.x());
        double y = normal.y() > 0.0 ? this.max.y() : (normal.y() < 0.0 ? this.min.y() : direction.y() * t + start.y());
        double z = normal.z() > 0.0 ? this.max.z() : (normal.z() < 0.0 ? this.min.z() : direction.z() * t + start.z());
        return Optional.of(new Tuple<Vector3d, Vector3d>(new Vector3d(x, y, z), normal));
    }

    @Override
    public SpongeAABB offset(double x, double y, double z) {
        return new SpongeAABB(this.min.add(x, y, z), this.max.add(x, y, z));
    }

    @Override
    public SpongeAABB expand(double x, double y, double z) {
        return new SpongeAABB(this.min.sub(x /= 2.0, y /= 2.0, z /= 2.0), this.max.add(x, y, z));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpongeAABB)) {
            return false;
        }
        SpongeAABB aabb = (SpongeAABB)other;
        return this.min.equals((Object)aabb.min) && this.max.equals((Object)aabb.max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String toString() {
        return "AABBImpl(" + String.valueOf(this.min) + " to " + String.valueOf(this.max) + ")";
    }

    public static class FactoryImpl
    implements AABB.Factory {
        @Override
        public AABB create(Vector3d v1, Vector3d v2) {
            Objects.requireNonNull(v1, "v1");
            Objects.requireNonNull(v2, "v2");
            return new SpongeAABB(v1, v2);
        }
    }
}

