/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.core.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SpongeLocation<W extends World<W, L>, L extends Location<W, L>>
implements Location<W, L> {
    protected final WeakReference<W> worldRef;
    private final Vector3d position;
    private final Vector3i blockPosition;
    private final Vector3i chunkPosition;
    private final Vector3i biomePosition;
    private final BlockPos pos;

    protected SpongeLocation(W world, ChunkLayout chunkLayout, Vector3d position) {
        this.worldRef = new WeakReference<W>(world);
        this.position = position;
        this.blockPosition = position.toInt();
        this.chunkPosition = chunkLayout.forceToChunk(this.blockPosition);
        this.biomePosition = position.toInt().mul(1, 0, 1);
        this.pos = new BlockPos(position.floorX(), position.floorY(), position.floorZ());
    }

    protected SpongeLocation(W worldRef, Vector3d position, Vector3i chunkPosition, Vector3i biomePosition) {
        this.worldRef = new WeakReference<W>(worldRef);
        this.position = position;
        this.blockPosition = position.toInt();
        this.chunkPosition = chunkPosition;
        this.biomePosition = biomePosition;
        this.pos = new BlockPos(position.floorX(), position.floorY(), position.floorZ());
    }

    @Override
    public W world() {
        World world = (World)this.worldRef.get();
        if (world == null) {
            throw new IllegalStateException("World Reference is no longer valid!");
        }
        return (W)world;
    }

    @Override
    public Optional<W> worldIfAvailable() {
        return Optional.ofNullable((World)this.worldRef.get());
    }

    @Override
    public boolean isAvailable() {
        return this.worldRef.get() != null;
    }

    @Override
    public boolean isValid() {
        return this.worldRef.get() != null;
    }

    @Override
    public Vector3d position() {
        return this.position;
    }

    @Override
    public Vector3i blockPosition() {
        return this.blockPosition;
    }

    @Override
    public Vector3i chunkPosition() {
        return this.chunkPosition;
    }

    @Override
    public Vector3i biomePosition() {
        return this.biomePosition;
    }

    @Override
    public double x() {
        return this.position.x();
    }

    @Override
    public double y() {
        return this.position.y();
    }

    @Override
    public double z() {
        return this.position.z();
    }

    @Override
    public int blockX() {
        return this.blockPosition.x();
    }

    @Override
    public int blockY() {
        return this.blockPosition.y();
    }

    @Override
    public int blockZ() {
        return this.blockPosition.z();
    }

    @Override
    public boolean inWorld(W world) {
        return this.worldRef.get() == world;
    }

    @Override
    public L withWorld(W world) {
        return (L)new SpongeLocation<W, L>(world, this.position, this.chunkPosition, this.biomePosition);
    }

    @Override
    public L withPosition(Vector3d position) {
        World world = (World)this.worldRef.get();
        if (world == null) {
            throw new IllegalStateException("World Reference is null!");
        }
        ChunkLayout chunkLayout = Sponge.server().chunkLayout();
        return (L)new SpongeLocation<World, L>(world, chunkLayout, position);
    }

    @Override
    public L withBlockPosition(Vector3i position) {
        World world = (World)this.worldRef.get();
        if (world == null) {
            throw new IllegalStateException("World Reference is null!");
        }
        ChunkLayout chunkLayout = Sponge.server().chunkLayout();
        return (L)new SpongeLocation<World, L>(world, chunkLayout, position.toDouble());
    }

    @Override
    public L sub(Vector3d v) {
        return this.withPosition(this.position.sub(v));
    }

    @Override
    public L sub(Vector3i v) {
        return this.withBlockPosition(this.blockPosition.sub(v));
    }

    @Override
    public L sub(double x, double y, double z) {
        return this.withPosition(this.position.sub(x, y, z));
    }

    @Override
    public L add(Vector3d v) {
        return this.withPosition(this.position.add(v));
    }

    @Override
    public L add(Vector3i v) {
        return this.withBlockPosition(this.blockPosition.add(v));
    }

    @Override
    public L add(double x, double y, double z) {
        return this.withPosition(this.position.add(x, y, z));
    }

    @Override
    public L relativeTo(Direction direction) {
        return null;
    }

    @Override
    public L relativeToBlock(Direction direction) {
        return null;
    }

    @Override
    public Biome biome() {
        return this.world().biome(this.blockPosition);
    }

    @Override
    public boolean hasBlock() {
        return this.isValid() && this.world().hasBlockState(this.blockPosition);
    }

    @Override
    public BlockState block() {
        return this.world().block(this.blockPosition);
    }

    @Override
    public FluidState fluid() {
        return this.world().fluid(this.blockPosition);
    }

    @Override
    public boolean hasBlockEntity() {
        return this.isValid() && this.world().blockEntity(this.blockPosition).isPresent();
    }

    @Override
    public Optional<? extends BlockEntity> blockEntity() {
        return this.world().blockEntity(this.blockPosition);
    }

    @Override
    public boolean setBlock(BlockState state) {
        return this.world().setBlock(this.blockPosition, state);
    }

    @Override
    public boolean setBlock(BlockState state, BlockChangeFlag flag) {
        return this.world().setBlock(this.blockPosition, state, flag);
    }

    @Override
    public boolean setBlockType(BlockType type) {
        return this.world().setBlock(this.blockPosition, (BlockState)type.defaultState());
    }

    @Override
    public boolean setBlockType(BlockType type, BlockChangeFlag flag) {
        return this.world().setBlock(this.blockPosition, (BlockState)type.defaultState(), flag);
    }

    public BlockPos asBlockPos() {
        return this.pos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocation that = (SpongeLocation)o;
        return ((World)this.worldRef.get()).equals(that.worldRef.get()) && this.position.equals((Object)that.position) && this.blockPosition.equals((Object)that.blockPosition);
    }

    public int hashCode() {
        return Objects.hash(this.worldRef.get(), this.position, this.blockPosition);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeLocation.class.getSimpleName() + "[", "]").add("worldRef=" + String.valueOf(this.worldRef)).add("position=" + String.valueOf(this.position)).toString();
    }
}

