/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.border;

import java.time.Duration;
import net.minecraft.world.level.border.WorldBorder;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.common.accessor.world.level.border.WorldBorder_SettingsAccessor;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.math.vector.Vector2d;

public final class SpongeWorldBorderBuilder
implements WorldBorder.Builder {
    private double diameter = -1.0;
    private double initialDiameter = -1.0;
    private Duration time = Duration.ZERO;
    private Vector2d center = Vector2d.ZERO;
    private Duration warningTime = Duration.ZERO;
    private double warningDistance;
    private double safeZone;
    private double damagePerBlock;

    @Override
    public WorldBorder.Builder from(WorldBorderBridge border) {
        return this.from(border.bridge$asImmutable());
    }

    @Override
    public WorldBorder.Builder from(org.spongepowered.api.world.border.WorldBorder border) {
        this.diameter = border.targetDiameter();
        this.initialDiameter = border.diameter();
        this.time = border.timeUntilTargetDiameter();
        this.center = border.center();
        this.warningTime = border.warningTime();
        this.warningDistance = border.warningDistance();
        this.safeZone = border.safeZone();
        this.damagePerBlock = border.damagePerBlock();
        return this;
    }

    @Override
    public WorldBorder.Builder overworldDefaults() {
        return this.from((org.spongepowered.api.world.border.WorldBorder)WorldBorder.DEFAULT_SETTINGS);
    }

    @Override
    public WorldBorder.Builder targetDiameter(double diameter) {
        if (diameter <= 0.0) {
            throw new IllegalArgumentException("diameter cannot be non-positive");
        }
        this.diameter = diameter;
        if (this.initialDiameter == -1.0) {
            this.initialDiameter = diameter;
        }
        return this;
    }

    @Override
    public WorldBorder.Builder timeToTargetDiameter(Duration time) {
        if (time.isNegative()) {
            throw new IllegalArgumentException("time cannot be negative");
        }
        this.time = time;
        return this;
    }

    @Override
    public WorldBorder.Builder center(double x, double z) {
        this.center = new Vector2d(x, z);
        return this;
    }

    @Override
    public WorldBorder.Builder initialDiameter(double initialDiameter) {
        if (initialDiameter <= 0.0) {
            throw new IllegalArgumentException("diameter cannot be non-positive");
        }
        this.initialDiameter = initialDiameter;
        if (this.diameter == -1.0) {
            this.diameter = initialDiameter;
        }
        return this;
    }

    @Override
    public WorldBorder.Builder safeZone(double safeZone) {
        if (safeZone < 0.0) {
            throw new IllegalArgumentException("damagePerBlock cannot be negative");
        }
        this.safeZone = safeZone;
        return this;
    }

    @Override
    public WorldBorder.Builder damagePerBlock(double damagePerBlock) {
        if (damagePerBlock <= 0.0) {
            throw new IllegalArgumentException("damagePerBlock cannot be non-positive");
        }
        this.damagePerBlock = damagePerBlock;
        return this;
    }

    @Override
    public WorldBorder.Builder warningTime(Duration warningTime) {
        if (warningTime.isNegative()) {
            throw new IllegalArgumentException("warning time cannot be negative");
        }
        this.warningTime = warningTime;
        return this;
    }

    @Override
    public WorldBorder.Builder warningDistance(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("warning distance cannot be negative");
        }
        this.warningDistance = distance;
        return this;
    }

    @Override
    public org.spongepowered.api.world.border.WorldBorder build() throws IllegalStateException {
        if (this.diameter == -1.0) {
            throw new IllegalStateException("The diameter or initial diameter has not been set!");
        }
        return (org.spongepowered.api.world.border.WorldBorder)WorldBorder_SettingsAccessor.invoker$new(this.center.x(), this.center.y(), this.damagePerBlock, this.safeZone, (int)this.warningDistance, (int)this.warningTime.getSeconds(), this.initialDiameter == -1.0 ? this.diameter : this.initialDiameter, this.time.toMillis(), this.diameter);
    }

    @Override
    public WorldBorder.Builder reset() {
        this.center = Vector2d.ZERO;
        this.damagePerBlock = 0.0;
        this.safeZone = 0.0;
        this.diameter = -1.0;
        this.initialDiameter = -1.0;
        this.time = Duration.ZERO;
        this.warningDistance = 0.0;
        this.warningTime = Duration.ZERO;
        return this;
    }
}

