/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.SchematicTemplate;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeSchematicTemplate
extends Record
implements SchematicTemplate {
    private final ResourceKey key;
    private final StructureTemplate nbtStructure;
    private final DataPack<SchematicTemplate> pack;

    public SpongeSchematicTemplate(ResourceKey key, StructureTemplate nbtStructure, DataPack<SchematicTemplate> pack) {
        this.key = key;
        this.nbtStructure = nbtStructure;
        this.pack = pack;
    }

    @Override
    public Schematic schematic() {
        return (Schematic)this.nbtStructure;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        CompoundTag serialized = SpongeSchematicTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        return NBTTranslator.INSTANCE.translateFrom(serialized);
    }

    public static CompoundTag encode(SchematicTemplate template, RegistryAccess registryAccess) {
        return ((SpongeSchematicTemplate)template).nbtStructure.save(new CompoundTag());
    }

    public static StructureTemplate decode(CompoundTag nbt, RegistryAccess registryAccess) {
        return SpongeCommon.server().getStructureManager().readStructure(nbt);
    }

    public static SpongeSchematicTemplate decode(DataPack<SchematicTemplate> pack, ResourceKey key, CompoundTag packEntry, RegistryAccess registryAccess) {
        StructureTemplate parsed = SpongeSchematicTemplate.decode(packEntry, registryAccess);
        return new SpongeSchematicTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeSchematicTemplate.class, "key;nbtStructure;pack", "key", "nbtStructure", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeSchematicTemplate.class, "key;nbtStructure;pack", "key", "nbtStructure", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeSchematicTemplate.class, "key;nbtStructure;pack", "key", "nbtStructure", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public StructureTemplate nbtStructure() {
        return this.nbtStructure;
    }

    @Override
    public DataPack<SchematicTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<SchematicTemplate, SchematicTemplate.Builder>
    implements SchematicTemplate.Builder {
        private DataPack<SchematicTemplate> pack = DataPacks.SCHEMATIC;
        private @Nullable StructureTemplate nbtStructure;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public SchematicTemplate.Builder from(SchematicTemplate value) {
            this.nbtStructure = ((SpongeSchematicTemplate)value).nbtStructure;
            return this;
        }

        @Override
        public SchematicTemplate.Builder reset() {
            this.pack = DataPacks.SCHEMATIC;
            this.nbtStructure = null;
            return this;
        }

        @Override
        public SchematicTemplate.Builder pack(DataPack<SchematicTemplate> pack) {
            this.pack = pack;
            return this;
        }

        @Override
        protected SpongeSchematicTemplate build0() {
            Objects.requireNonNull(this.nbtStructure, "structure");
            return new SpongeSchematicTemplate(this.key, this.nbtStructure, this.pack);
        }
    }
}

