/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure.jigsaw;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.jigsaw.Processor;
import org.spongepowered.api.world.generation.structure.jigsaw.ProcessorList;
import org.spongepowered.api.world.generation.structure.jigsaw.ProcessorListTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeProcessorListTemplate
extends Record
implements ProcessorListTemplate {
    private final ResourceKey key;
    private final StructureProcessorList representedProcessors;
    private final DataPack<ProcessorListTemplate> pack;

    public SpongeProcessorListTemplate(ResourceKey key, StructureProcessorList representedProcessors, DataPack<ProcessorListTemplate> pack) {
        this.key = key;
        this.representedProcessors = representedProcessors;
        this.pack = pack;
    }

    @Override
    public ProcessorList processorList() {
        return (ProcessorList)this.representedProcessors;
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement serialized = SpongeProcessorListTemplate.encode(this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized ProcessorList:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(ProcessorListTemplate template, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (JsonElement)StructureProcessorType.LIST_OBJECT_CODEC.encodeStart((DynamicOps)ops, (Object)((StructureProcessorList)template.processorList())).getOrThrow();
    }

    public static StructureProcessorList decode(JsonElement json, RegistryAccess registryAccess) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        return (StructureProcessorList)StructureProcessorType.LIST_OBJECT_CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeProcessorListTemplate decode(DataPack<ProcessorListTemplate> pack, ResourceKey key, JsonElement json, RegistryAccess registryAccess) {
        StructureProcessorList parsed = SpongeProcessorListTemplate.decode(json, registryAccess);
        return new SpongeProcessorListTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeProcessorListTemplate.class, "key;representedProcessors;pack", "key", "representedProcessors", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeProcessorListTemplate.class, "key;representedProcessors;pack", "key", "representedProcessors", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeProcessorListTemplate.class, "key;representedProcessors;pack", "key", "representedProcessors", "pack"}, this, o);
    }

    @Override
    public ResourceKey key() {
        return this.key;
    }

    public StructureProcessorList representedProcessors() {
        return this.representedProcessors;
    }

    @Override
    public DataPack<ProcessorListTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<ProcessorList, ProcessorListTemplate, ProcessorListTemplate.Builder>
    implements ProcessorListTemplate.Builder {
        private @Nullable StructureProcessorList processorList;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<ProcessorListTemplate, ProcessorList> valueExtractor() {
            return value -> (ProcessorList)((SpongeProcessorListTemplate)value).representedProcessors;
        }

        @Override
        public ProcessorListTemplate.Builder fromValues(List<Processor> processorList) {
            this.processorList = new StructureProcessorList(processorList);
            return this;
        }

        @Override
        public ProcessorListTemplate.Builder fromValue(ProcessorList processorList) {
            this.processorList = (StructureProcessorList)processorList;
            return this;
        }

        @Override
        public ProcessorListTemplate.Builder reset() {
            this.pack = DataPacks.PROCESSOR_LIST;
            this.key = null;
            this.processorList = null;
            return this;
        }

        @Override
        public ProcessorListTemplate.Builder fromDataPack(DataView datapack) throws IOException {
            JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(datapack));
            StructureProcessorList decoded = SpongeProcessorListTemplate.decode(json, (RegistryAccess)SpongeCommon.server().registryAccess());
            this.fromValue((ProcessorList)decoded);
            return this;
        }

        @Override
        protected SpongeProcessorListTemplate build0() {
            Objects.requireNonNull(this.processorList, "processorList");
            return new SpongeProcessorListTemplate(this.key, this.processorList, this.pack);
        }
    }
}

