/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeLocatableBlock
implements LocatableBlock {
    private final BlockState blockState;
    private final ResourceKey world;
    private final Vector3i position;
    private final WeakReference<ServerWorld> worldRef;
    private @Nullable ServerLocation location;

    SpongeLocatableBlock(SpongeLocatableBlockBuilder builder) {
        this.blockState = Objects.requireNonNull(builder.blockState.get(), "blockstate");
        this.position = Objects.requireNonNull(builder.position.get(), "position");
        this.world = Objects.requireNonNull(builder.world.get(), "world");
        this.worldRef = new WeakReference<ServerWorld>(Objects.requireNonNull(builder.worldReference.get(), "reference"));
    }

    SpongeLocatableBlock(ServerWorld world, int x, int y, int z) {
        this.world = world.key();
        this.worldRef = new WeakReference<ServerWorld>(world);
        this.position = new Vector3i(x, y, z);
        this.blockState = world.block(x, y, z);
    }

    @Override
    public BlockState blockState() {
        return this.blockState;
    }

    @Override
    public World<?, ?> world() {
        return Objects.requireNonNull((ServerWorld)this.worldRef.get(), "World was de-referenced!");
    }

    public ServerLocation location() {
        if (this.location == null) {
            this.location = ServerLocation.of(Objects.requireNonNull((ServerWorld)this.worldRef.get(), "World was de-referenced!"), this.position);
        }
        return this.location;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, 1).set(Queries.WORLD_KEY, this.world).set(Queries.POSITION_X, this.position.x()).set(Queries.POSITION_Y, this.position.y()).set(Queries.POSITION_Z, this.position.z()).set(Constants.Block.BLOCK_STATE, this.blockState);
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.blockState.get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.blockState.getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.blockState.supports(key);
    }

    @Override
    public LocatableBlock copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.blockState.getKeys();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.blockState.getValues();
    }

    @Override
    public <E> Optional<LocatableBlock> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        return this.blockState.transform(key, function).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public <E> Optional<LocatableBlock> with(Key<? extends Value<E>> key, E value) {
        return this.blockState.with(key, value).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public Optional<LocatableBlock> with(Value<?> value) {
        return this.blockState.with(value).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public Optional<LocatableBlock> without(Key<?> key) {
        return this.blockState.without(key).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public LocatableBlock withRawData(DataView container) throws InvalidDataException {
        return LocatableBlock.builder().from(this).state((BlockState)this.blockState.withRawData(container)).build();
    }

    @Override
    public LocatableBlock mergeWith(LocatableBlock that, MergeFunction function) {
        return LocatableBlock.builder().from(this).state(this.blockState.mergeWith(that.blockState(), function)).build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return this.blockState.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocatableBlock that = (SpongeLocatableBlock)o;
        return Objects.equals(this.blockState, that.blockState) && Objects.equals(this.position, that.position) && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.position, this.world);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeLocatableBlock.class.getSimpleName() + "[", "]").add("blockState=" + String.valueOf(this.blockState)).add("world=" + String.valueOf(this.world)).add("position=" + String.valueOf(this.position)).toString();
    }
}

