/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.server.TicketType;
import org.spongepowered.common.accessor.server.level.TicketTypeAccessor;

public final class SpongeTicketTypeBuilder<T>
implements TicketType.Builder<T> {
    private @MonotonicNonNull String name;
    private @Nullable Comparator<T> comparator;
    private @MonotonicNonNull Ticks lifetime;

    @Override
    public TicketType.Builder<T> reset() {
        this.name = null;
        this.comparator = null;
        this.lifetime = null;
        return this;
    }

    @Override
    public TicketType.Builder<T> name(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot null");
        return this;
    }

    @Override
    public TicketType.Builder<T> comparator(@Nullable Comparator<T> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public TicketType.Builder<T> lifetime(Ticks lifetime) {
        Objects.requireNonNull(lifetime, "Lifetime cannot be null");
        if (!lifetime.isInfinite() && lifetime.ticks() <= 0L) {
            throw new IllegalArgumentException("The lifetime is required to be a positive integer");
        }
        this.lifetime = lifetime;
        return this;
    }

    @Override
    public TicketType<T> build() {
        Objects.requireNonNull(this.name, "Name cannot null");
        Objects.requireNonNull(this.lifetime, "Lifetime cannot be null");
        if (this.comparator == null) {
            this.comparator = (v1, v2) -> 0;
        }
        return (TicketType)TicketTypeAccessor.accessor$createInstance(this.name, this.comparator, this.lifetime.isInfinite() ? 0L : this.lifetime.ticks());
    }
}

