/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.level.border.WorldBorder;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.teleport.TeleportHelper;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.math.GenericMath;
import org.spongepowered.math.vector.Vector3i;

@Singleton
public final class SpongeTeleportHelper
implements TeleportHelper {
    @Override
    public Optional<ServerLocation> findSafeLocation(ServerLocation location, int height, int width, int distanceToDrop, TeleportHelperFilter filter, TeleportHelperFilter ... additionalFilters) {
        ServerWorld world = (ServerWorld)location.world();
        HashSet filters = Sets.newHashSet((Object[])additionalFilters);
        filters.add(filter);
        if (SpongeConfigs.getCommon().get().teleportHelper.forceBlacklist) {
            filters.add(TeleportHelperFilters.CONFIG.get());
        }
        Optional<Vector3i> result = this.getSafeLocation(world, this.getBlockLocations(location, height, width), distanceToDrop, filters);
        return result.map(vector3i -> ServerLocation.of(world, vector3i.toDouble().add(0.5, 0.0, 0.5)));
    }

    private Stream<Vector3i> getBlockLocations(ServerLocation worldLocation, int height, int width) {
        WorldBorder.Settings worldBorder = (WorldBorder.Settings)((ServerWorld)worldLocation.world()).properties().worldBorder();
        double radius = worldBorder.getSize() / 2.0;
        int worldBorderMinX = GenericMath.floor((double)(worldBorder.getCenterX() - radius));
        int worldBorderMinZ = GenericMath.floor((double)(worldBorder.getCenterZ() - radius));
        int worldBorderMaxX = GenericMath.floor((double)(worldBorder.getCenterX() + radius));
        int worldBorderMaxZ = GenericMath.floor((double)(worldBorder.getCenterZ() + radius));
        int worldMaxY = ((ServerWorld)worldLocation.world()).max().y();
        Vector3i vectorLocation = worldLocation.blockPosition();
        int minY = GenericMath.clamp((int)(vectorLocation.y() - height), (int)0, (int)worldMaxY);
        int maxY = GenericMath.clamp((int)(vectorLocation.y() + height), (int)0, (int)worldMaxY);
        int minX = GenericMath.clamp((int)(vectorLocation.x() - width), (int)worldBorderMinX, (int)worldBorderMaxX);
        int maxX = GenericMath.clamp((int)(vectorLocation.x() + width), (int)worldBorderMinX, (int)worldBorderMaxX);
        int minZ = GenericMath.clamp((int)(vectorLocation.z() - width), (int)worldBorderMinZ, (int)worldBorderMaxZ);
        int maxZ = GenericMath.clamp((int)(vectorLocation.z() + width), (int)worldBorderMinZ, (int)worldBorderMaxZ);
        ArrayList<Vector3i> vectors = new ArrayList<Vector3i>();
        for (int y = minY; y <= maxY; ++y) {
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int z = minZ; z <= maxZ; ++z) {
                    vectors.add(new Vector3i(x2, y, z));
                }
            }
        }
        Comparator<Vector3i> c = Comparator.comparingInt(arg_0 -> ((Vector3i)vectorLocation).distanceSquared(arg_0));
        c = c.thenComparing(x -> -Math.abs(vectorLocation.y() - x.y())).thenComparing(x -> -x.y());
        return vectors.stream().sorted(c);
    }

    private Optional<Vector3i> getSafeLocation(ServerWorld world, Stream<Vector3i> positionsToCheck, int floorDistanceCheck, Collection<TeleportHelperFilter> filters) {
        HashMap blockCache = new HashMap();
        return positionsToCheck.filter(currentTarget -> {
            ArrayList<TeleportHelperFilter> undefinedResults = new ArrayList<TeleportHelperFilter>();
            for (TeleportHelperFilter filter : filters) {
                Tristate isValid = filter.isValidLocation(world, (Vector3i)currentTarget);
                if (isValid == Tristate.FALSE) {
                    return false;
                }
                if (isValid != Tristate.UNDEFINED) continue;
                undefinedResults.add(filter);
            }
            if (undefinedResults.isEmpty()) {
                return true;
            }
            BlockData block = this.getBlockData((Vector3i)currentTarget, world, blockCache, (Collection<TeleportHelperFilter>)undefinedResults);
            return block.isSafeBody && this.getBlockData((Vector3i)currentTarget.add((int)0, (int)1, (int)0), (World)world, (Map<Vector3i, BlockData>)blockCache, undefinedResults).isSafeBody && (floorDistanceCheck <= 0 || this.isFloorSafe((Vector3i)currentTarget, world, blockCache, (Collection<TeleportHelperFilter>)undefinedResults, floorDistanceCheck));
        }).findFirst();
    }

    private boolean isFloorSafe(Vector3i currentTarget, World world, Map<Vector3i, BlockData> blockCache, Collection<TeleportHelperFilter> filters, int floorDistanceCheck) {
        for (int i = 1; i < floorDistanceCheck; ++i) {
            BlockData data = this.getBlockData(currentTarget.sub(0, i, 0), world, blockCache, filters);
            if (data.isSafeFloor) {
                return true;
            }
            if (data.isSafeBody) continue;
            return false;
        }
        return this.getBlockData((Vector3i)currentTarget.sub((int)0, (int)floorDistanceCheck, (int)0), (World)world, blockCache, filters).isSafeFloor;
    }

    private BlockData getBlockData(Vector3i vector3i, World world, Map<Vector3i, BlockData> cache, Collection<TeleportHelperFilter> filters) {
        if (vector3i.y() < 0) {
            return new BlockData(this);
        }
        if (cache.containsKey(vector3i)) {
            return cache.get(vector3i);
        }
        BlockData data = new BlockData(this, world.block(vector3i), filters);
        cache.put(vector3i, data);
        return data;
    }

    private class BlockData {
        private final boolean isSafeFloor;
        private final boolean isSafeBody;

        private BlockData(SpongeTeleportHelper spongeTeleportHelper) {
            this.isSafeFloor = false;
            this.isSafeBody = false;
        }

        private BlockData(SpongeTeleportHelper spongeTeleportHelper, BlockState blockState, Collection<TeleportHelperFilter> filters) {
            this.isSafeFloor = filters.stream().allMatch(x -> x.isSafeFloorMaterial(blockState));
            this.isSafeBody = filters.stream().allMatch(x -> x.isSafeBodyMaterial(blockState));
        }
    }
}

