/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin_Vanilla
implements ServerLoginPacketListener {
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    @Shadow
    @Final
    Connection connection;
    @Shadow
    private GameProfile authenticatedProfile;
    private static final int HANDSHAKE_NOT_STARTED = 0;
    private static final int HANDSHAKE_CLIENT_TYPE = 1;
    private static final int HANDSHAKE_SYNC_CHANNEL_REGISTRATIONS = 2;
    private static final int HANDSHAKE_CHANNEL_REGISTRATION = 3;
    private static final int HANDSHAKE_SYNC_PLUGIN_DATA = 4;
    private int impl$handshakeState = 0;

    @Inject(method={"handleCustomQueryPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onResponsePayload(ServerboundCustomQueryAnswerPacket packet, CallbackInfo ci) {
        ci.cancel();
        SpongeChannelManager channelRegistry = (SpongeChannelManager)Sponge.channelManager();
        this.server.execute(() -> channelRegistry.handleLoginResponsePayload(((ConnectionBridge)this.connection).bridge$getEngineConnection(), (EngineConnectionState)((Object)this), packet));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void impl$onTick(CallbackInfo ci) {
        if (this.state == ServerLoginPacketListenerImpl.State.NEGOTIATING) {
            TransactionStore store;
            ServerSideConnection connection = (ServerSideConnection)((Object)((ConnectionBridge)this.connection).bridge$getEngineConnection());
            if (this.impl$handshakeState == 0) {
                this.impl$handshakeState = 1;
                ((SpongeChannelManager)Sponge.channelManager()).requestClientType(connection).thenAccept(result -> {
                    this.impl$handshakeState = 2;
                });
            } else if (this.impl$handshakeState == 2) {
                this.impl$handshakeState = 3;
                ((SpongeChannelManager)Sponge.channelManager()).sendLoginChannelRegistry(connection).thenAccept(result -> {
                    Cause cause = Cause.of(EventContext.empty(), this);
                    ServerSideConnectionEvent.Handshake event = SpongeEventFactory.createServerSideConnectionEventHandshake(cause, connection, SpongeGameProfile.of(this.authenticatedProfile));
                    SpongeCommon.post(event);
                    this.impl$handshakeState = 4;
                });
            } else if (this.impl$handshakeState == 4 && (store = ConnectionUtil.getTransactionStore(connection)).isEmpty()) {
                this.state = ServerLoginPacketListenerImpl.State.VERIFYING;
            }
        }
    }
}

