/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.world.level.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.MixinTargetHelper;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.block.entity.AbstractFurnaceBlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.block.entity.BaseContainerBlockEntityMixin;
import org.spongepowered.vanilla.accessor.world.level.block.entity.AbstractFurnaceBlockEntityAccessor_Vanilla;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin_Vanilla
extends BaseContainerBlockEntityMixin
implements AbstractFurnaceBlockEntityBridge {
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    int cookingProgress;
    private boolean vanilla$filledWaterBucket;

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;canBurn(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/item/crafting/RecipeHolder;Lnet/minecraft/core/NonNullList;I)Z", ordinal=1))
    private static boolean vanillaImpl$checkIfCanSmelt(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> slots, int maxStackSize, Level level, BlockPos entityPos, BlockState state, AbstractFurnaceBlockEntity entity) {
        if (!AbstractFurnaceBlockEntityAccessor_Vanilla.invoker$canBurn(registryAccess, recipe, slots, maxStackSize)) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)slots.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        if (((AbstractFurnaceBlockEntityMixin_Vanilla)entity).cookingProgress == 0) {
            CookingEvent.Start event = SpongeEventFactory.createCookingEventStart(cause, (FurnaceBlockEntity)entity, Optional.of(fuel), Optional.of((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()));
            SpongeCommon.post(event);
            return !event.isCancelled();
        }
        ItemStackSnapshot cooking = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)entity, cooking, Optional.of(fuel), Optional.of((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()));
        SpongeCommon.post(event);
        return !event.isCancelled();
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"))
    private static int vanillaImpl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime, Level level, BlockPos entityPos, BlockState state, AbstractFurnaceBlockEntity entity) {
        int clampedCookTime = Mth.clamp((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = ((AbstractFurnaceBlockEntityMixin_Vanilla)entity).bridge$getCurrentRecipe();
        ItemStackSnapshot cooking = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)entity, cooking, Optional.of(fuel), recipe.map(r -> (CookingRecipe)r.value()), recipe.map(r -> (ResourceKey)r.id()));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return ((AbstractFurnaceBlockEntityMixin_Vanilla)entity).cookingProgress;
        }
        return clampedCookTime;
    }

    @Inject(method={"burn"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/level/block/Blocks;WET_SPONGE:Lnet/minecraft/world/level/block/Block;", opcode=178))})
    private static void vanilla$captureBucketFill(RegistryAccess $$0, RecipeHolder<?> $$1, NonNullList<ItemStack> $$2, int $$3, CallbackInfoReturnable<Boolean> cir) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        FurnaceBlockEntity entity = cause.first(FurnaceBlockEntity.class).orElseThrow(() -> new IllegalStateException("Expected to have a FurnaceBlockEntity in the Cause"));
        AbstractFurnaceBlockEntityMixin_Vanilla mixinSelf = (AbstractFurnaceBlockEntityMixin_Vanilla)MixinTargetHelper.cast(entity);
        mixinSelf.vanilla$filledWaterBucket = true;
    }

    @Inject(method={"burn"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V", shift=At.Shift.AFTER)})
    private static void vanillaImpl$afterSmeltItem(RegistryAccess registryAccess, RecipeHolder<?> recipe, NonNullList<ItemStack> slots, int var2, CallbackInfoReturnable<Boolean> cir, ItemStack $$4, ItemStack $$5, ItemStack $$6) {
        boolean hasFuel;
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        FurnaceBlockEntity entity = cause.first(FurnaceBlockEntity.class).orElseThrow(() -> new IllegalStateException("Expected to have a FurnaceBlockEntity in the Cause"));
        AbstractFurnaceBlockEntityMixin_Vanilla mixinSelf = (AbstractFurnaceBlockEntityMixin_Vanilla)MixinTargetHelper.cast(entity);
        ArrayList<SlotTransaction> transactions = new ArrayList<SlotTransaction>();
        $$4.grow(1);
        ItemStackSnapshot originalSmeltItem = ItemStackUtil.snapshotOf($$4);
        $$4.shrink(1);
        transactions.add(new SlotTransaction(entity.inventory().slot(0).get(), originalSmeltItem, ItemStackUtil.snapshotOf($$4)));
        boolean bl = hasFuel = !mixinSelf.vanilla$filledWaterBucket;
        if (mixinSelf.vanilla$filledWaterBucket) {
            transactions.add(new SlotTransaction(entity.inventory().slot(1).get(), ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf((ItemStack)slots.get(1))));
        }
        mixinSelf.vanilla$filledWaterBucket = false;
        if ($$6.isEmpty()) {
            transactions.add(new SlotTransaction(entity.inventory().slot(2).get(), ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf($$5)));
        } else if (ItemStack.isSameItemSameComponents((ItemStack)$$6, (ItemStack)$$5)) {
            $$6.shrink(1);
            ItemStackSnapshot originalResult = ItemStackUtil.snapshotOf($$6);
            $$6.grow(1);
            transactions.add(new SlotTransaction(entity.inventory().slot(2).get(), originalResult, ItemStackUtil.snapshotOf($$6)));
        }
        Optional<ItemStackSnapshot> fuel = hasFuel && !((ItemStack)slots.get(1)).isEmpty() ? Optional.of(ItemStackUtil.snapshotOf((ItemStack)slots.get(1))) : Optional.empty();
        CookingEvent.Finish event = SpongeEventFactory.createCookingEventFinish(cause, entity, fuel, Optional.ofNullable((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()), Collections.unmodifiableList(transactions));
        SpongeCommon.post(event);
        for (SlotTransaction transaction : transactions) {
            transaction.custom().ifPresent(item -> slots.set(((SlotAdapter)transaction.slot()).getOrdinal(), (Object)ItemStackUtil.fromSnapshotToNative(item)));
        }
    }
}

