/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.SyslogFacility;
import org.tinylog.writers.raw.SyslogSeverity;

public abstract class AbstractSocketWriter
extends AbstractFormatPatternWriter {
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final int DEFAULT_PORT_NUMBER = 514;
    private static final String DEFAULT_FACILITY = "USER";
    private static final int FACILITY_CODE_SHIFT = 3;
    private static final String DEFAULT_SEVERITY = "INFORMATIONAL";
    private final InetAddress inetAddress;
    private final int port;
    private final Charset charset;
    private final String identification;

    public AbstractSocketWriter(Map<String, String> properties) throws UnknownHostException {
        super(properties);
        String host = this.getStringValue("host");
        if (host == null) {
            host = DEFAULT_HOST_NAME;
        }
        this.inetAddress = InetAddress.getByName(DEFAULT_HOST_NAME);
        String portNumber = this.getStringValue("port");
        this.port = portNumber == null ? 514 : Integer.parseInt(portNumber);
        this.charset = super.getCharset();
        String identification = this.getStringValue("identification");
        this.identification = identification == null ? "" : identification;
    }

    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public final int getPort() {
        return this.port;
    }

    public int getCode(Level level) {
        String facility = this.getStringValue("facility");
        String severity = this.getStringValue("severity");
        if (facility == null) {
            facility = DEFAULT_FACILITY;
        }
        int facilityCode = SyslogFacility.valueOf(facility).getCode();
        if (severity == null) {
            severity = level != null ? SyslogSeverity.getSeverity(level).name() : DEFAULT_SEVERITY;
        }
        int severityCode = SyslogSeverity.valueOf(severity).getCode();
        return (facilityCode << 3) + severityCode;
    }

    public byte[] formatMessage(LogEntry logEntry) {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.getCode(logEntry.getLevel()));
        builder.append(">");
        builder.append(this.identification);
        builder.append(": ");
        builder.append(this.render(logEntry));
        return builder.toString().getBytes(this.charset);
    }
}

